/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.URISyntaxException;
import java.util.function.BiFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ReactorServerHttpRequest;
import org.springframework.http.server.reactive.ReactorServerHttpResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.server.HttpServerRequest;
import reactor.ipc.netty.http.server.HttpServerResponse;

public class ReactorHttpHandlerAdapter
implements BiFunction<HttpServerRequest, HttpServerResponse, Mono<Void>> {
    private static final Log logger = LogFactory.getLog(ReactorHttpHandlerAdapter.class);
    private final HttpHandler httpHandler;

    public ReactorHttpHandlerAdapter(HttpHandler httpHandler) {
        Assert.notNull((Object)httpHandler, (String)"HttpHandler must not be null");
        this.httpHandler = httpHandler;
    }

    @Override
    public Mono<Void> apply(HttpServerRequest request, HttpServerResponse response) {
        ReactorServerHttpResponse adaptedResponse;
        ReactorServerHttpRequest adaptedRequest;
        NettyDataBufferFactory bufferFactory = new NettyDataBufferFactory(response.alloc());
        try {
            adaptedRequest = new ReactorServerHttpRequest(request, bufferFactory);
            adaptedResponse = new ReactorServerHttpResponse(response, (DataBufferFactory)bufferFactory);
        }
        catch (URISyntaxException ex2) {
            logger.error((Object)("Invalid URL " + ex2.getMessage()), (Throwable)ex2);
            response.status(HttpResponseStatus.BAD_REQUEST);
            return Mono.empty();
        }
        return this.httpHandler.handle(adaptedRequest, adaptedResponse).onErrorResume(ex -> {
            logger.error((Object)"Could not complete request", ex);
            response.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            return Mono.empty();
        }).doOnSuccess(aVoid -> logger.debug((Object)"Successfully completed request"));
    }
}

