/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

final class HierarchicalUriComponents
extends UriComponents {
    private static final char PATH_DELIMITER = '/';
    private static final String PATH_DELIMITER_STRING = "/";
    private final String userInfo;
    private final String host;
    private final String port;
    private final PathComponent path;
    private final MultiValueMap<String, String> queryParams;
    private final boolean encoded;
    static final PathComponent NULL_PATH_COMPONENT = new PathComponent(){

        @Override
        public String getPath() {
            return "";
        }

        @Override
        public List<String> getPathSegments() {
            return Collections.emptyList();
        }

        @Override
        public PathComponent encode(Charset charset) {
            return this;
        }

        @Override
        public void verify() {
        }

        @Override
        public PathComponent expand(UriComponents.UriTemplateVariables uriVariables) {
            return this;
        }

        @Override
        public void copyToUriComponentsBuilder(UriComponentsBuilder builder) {
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    };

    HierarchicalUriComponents(@Nullable String scheme, @Nullable String fragment, @Nullable String userInfo, @Nullable String host, @Nullable String port, @Nullable PathComponent path, @Nullable MultiValueMap<String, String> queryParams, boolean encoded, boolean verify) {
        super(scheme, fragment);
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.path = path != null ? path : NULL_PATH_COMPONENT;
        this.queryParams = CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)(queryParams != null ? queryParams : new LinkedMultiValueMap(0)));
        this.encoded = encoded;
        if (verify) {
            this.verify();
        }
    }

    @Override
    public String getSchemeSpecificPart() {
        return null;
    }

    @Override
    public String getUserInfo() {
        return this.userInfo;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        if (this.port == null) {
            return -1;
        }
        if (this.port.contains("{")) {
            throw new IllegalStateException("The port contains a URI variable but has not been expanded yet: " + this.port);
        }
        return Integer.parseInt(this.port);
    }

    @Override
    public String getPath() {
        return this.path.getPath();
    }

    @Override
    public List<String> getPathSegments() {
        return this.path.getPathSegments();
    }

    @Override
    public String getQuery() {
        if (!this.queryParams.isEmpty()) {
            StringBuilder queryBuilder = new StringBuilder();
            for (Map.Entry entry : this.queryParams.entrySet()) {
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)values)) {
                    if (queryBuilder.length() != 0) {
                        queryBuilder.append('&');
                    }
                    queryBuilder.append(name);
                    continue;
                }
                for (Object value : values) {
                    if (queryBuilder.length() != 0) {
                        queryBuilder.append('&');
                    }
                    queryBuilder.append(name);
                    if (value == null) continue;
                    queryBuilder.append('=');
                    queryBuilder.append(value.toString());
                }
            }
            return queryBuilder.toString();
        }
        return null;
    }

    @Override
    public MultiValueMap<String, String> getQueryParams() {
        return this.queryParams;
    }

    @Override
    public HierarchicalUriComponents encode(Charset charset) {
        if (this.encoded) {
            return this;
        }
        String scheme = this.getScheme();
        String fragment = this.getFragment();
        String schemeTo = scheme != null ? HierarchicalUriComponents.encodeUriComponent(scheme, charset, Type.SCHEME) : null;
        String fragmentTo = fragment != null ? HierarchicalUriComponents.encodeUriComponent(fragment, charset, Type.FRAGMENT) : null;
        String userInfoTo = HierarchicalUriComponents.encodeUriComponent(this.userInfo, charset, Type.USER_INFO);
        String hostTo = HierarchicalUriComponents.encodeUriComponent(this.host, charset, this.getHostType());
        PathComponent pathTo = this.path.encode(charset);
        MultiValueMap<String, String> paramsTo = this.encodeQueryParams(charset);
        return new HierarchicalUriComponents(schemeTo, fragmentTo, userInfoTo, hostTo, this.port, pathTo, paramsTo, true, false);
    }

    private MultiValueMap<String, String> encodeQueryParams(Charset charset) {
        int size = this.queryParams.size();
        LinkedMultiValueMap result = new LinkedMultiValueMap(size);
        for (Map.Entry entry : this.queryParams.entrySet()) {
            String name = HierarchicalUriComponents.encodeUriComponent((String)entry.getKey(), charset, Type.QUERY_PARAM);
            ArrayList<String> values = new ArrayList<String>(((List)entry.getValue()).size());
            for (String value : (List)entry.getValue()) {
                values.add(HierarchicalUriComponents.encodeUriComponent(value, charset, Type.QUERY_PARAM));
            }
            result.put((Object)name, values);
        }
        return result;
    }

    @Nullable
    static String encodeUriComponent(String source, String encoding, Type type) {
        return HierarchicalUriComponents.encodeUriComponent(source, Charset.forName(encoding), type);
    }

    static String encodeUriComponent(String source, Charset charset, Type type) {
        if (!StringUtils.hasLength((String)source)) {
            return source;
        }
        Assert.notNull((Object)charset, (String)"Charset must not be null");
        Assert.notNull((Object)((Object)type), (String)"Type must not be null");
        byte[] bytes = source.getBytes(charset);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);
        boolean changed = false;
        for (byte b : bytes) {
            if (b < 0) {
                b = (byte)(b + 256);
            }
            if (type.isAllowed(b)) {
                bos.write(b);
                continue;
            }
            bos.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            bos.write(hex1);
            bos.write(hex2);
            changed = true;
        }
        return changed ? new String(bos.toByteArray(), charset) : source;
    }

    private Type getHostType() {
        return this.host != null && this.host.startsWith("[") ? Type.HOST_IPV6 : Type.HOST_IPV4;
    }

    private void verify() {
        if (!this.encoded) {
            return;
        }
        HierarchicalUriComponents.verifyUriComponent(this.getScheme(), Type.SCHEME);
        HierarchicalUriComponents.verifyUriComponent(this.userInfo, Type.USER_INFO);
        HierarchicalUriComponents.verifyUriComponent(this.host, this.getHostType());
        this.path.verify();
        for (Map.Entry entry : this.queryParams.entrySet()) {
            HierarchicalUriComponents.verifyUriComponent((String)entry.getKey(), Type.QUERY_PARAM);
            for (String value : (List)entry.getValue()) {
                HierarchicalUriComponents.verifyUriComponent(value, Type.QUERY_PARAM);
            }
        }
        HierarchicalUriComponents.verifyUriComponent(this.getFragment(), Type.FRAGMENT);
    }

    private static void verifyUriComponent(@Nullable String source, Type type) {
        if (source == null) {
            return;
        }
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source.charAt(i + 1);
                    char hex2 = source.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u == -1 || l == -1) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                    }
                    i += 2;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            if (type.isAllowed(ch)) continue;
            throw new IllegalArgumentException("Invalid character '" + ch + "' for " + type.name() + " in \"" + source + "\"");
        }
    }

    @Override
    protected HierarchicalUriComponents expandInternal(UriComponents.UriTemplateVariables uriVariables) {
        Assert.state((!this.encoded ? 1 : 0) != 0, (String)"Cannot expand an already encoded UriComponents object");
        String schemeTo = HierarchicalUriComponents.expandUriComponent(this.getScheme(), uriVariables);
        String fragmentTo = HierarchicalUriComponents.expandUriComponent(this.getFragment(), uriVariables);
        String userInfoTo = HierarchicalUriComponents.expandUriComponent(this.userInfo, uriVariables);
        String hostTo = HierarchicalUriComponents.expandUriComponent(this.host, uriVariables);
        String portTo = HierarchicalUriComponents.expandUriComponent(this.port, uriVariables);
        PathComponent pathTo = this.path.expand(uriVariables);
        MultiValueMap<String, String> paramsTo = this.expandQueryParams(uriVariables);
        return new HierarchicalUriComponents(schemeTo, fragmentTo, userInfoTo, hostTo, portTo, pathTo, paramsTo, false, false);
    }

    private MultiValueMap<String, String> expandQueryParams(UriComponents.UriTemplateVariables variables) {
        int size = this.queryParams.size();
        LinkedMultiValueMap result = new LinkedMultiValueMap(size);
        variables = new QueryUriTemplateVariables(variables);
        for (Map.Entry entry : this.queryParams.entrySet()) {
            String name = HierarchicalUriComponents.expandUriComponent((String)entry.getKey(), variables);
            ArrayList<String> values = new ArrayList<String>(((List)entry.getValue()).size());
            for (String value : (List)entry.getValue()) {
                values.add(HierarchicalUriComponents.expandUriComponent(value, variables));
            }
            result.put((Object)name, values);
        }
        return result;
    }

    @Override
    public UriComponents normalize() {
        String normalizedPath = StringUtils.cleanPath((String)this.getPath());
        return new HierarchicalUriComponents(this.getScheme(), this.getFragment(), this.userInfo, this.host, this.port, new FullPathComponent(normalizedPath), this.queryParams, this.encoded, false);
    }

    @Override
    public String toUriString() {
        String query;
        String path;
        StringBuilder uriBuilder = new StringBuilder();
        if (this.getScheme() != null) {
            uriBuilder.append(this.getScheme());
            uriBuilder.append(':');
        }
        if (this.userInfo != null || this.host != null) {
            uriBuilder.append("//");
            if (this.userInfo != null) {
                uriBuilder.append(this.userInfo);
                uriBuilder.append('@');
            }
            if (this.host != null) {
                uriBuilder.append(this.host);
            }
            if (this.getPort() != -1) {
                uriBuilder.append(':');
                uriBuilder.append(this.port);
            }
        }
        if (StringUtils.hasLength((String)(path = this.getPath()))) {
            if (uriBuilder.length() != 0 && path.charAt(0) != '/') {
                uriBuilder.append('/');
            }
            uriBuilder.append(path);
        }
        if ((query = this.getQuery()) != null) {
            uriBuilder.append('?');
            uriBuilder.append(query);
        }
        if (this.getFragment() != null) {
            uriBuilder.append('#');
            uriBuilder.append(this.getFragment());
        }
        return uriBuilder.toString();
    }

    @Override
    public URI toUri() {
        try {
            if (this.encoded) {
                return new URI(this.toString());
            }
            String path = this.getPath();
            if (StringUtils.hasLength((String)path) && path.charAt(0) != '/' && (this.getScheme() != null || this.getUserInfo() != null || this.getHost() != null || this.getPort() != -1)) {
                path = '/' + path;
            }
            return new URI(this.getScheme(), this.getUserInfo(), this.getHost(), this.getPort(), path, this.getQuery(), this.getFragment());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not create URI object: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected void copyToUriComponentsBuilder(UriComponentsBuilder builder) {
        if (this.getScheme() != null) {
            builder.scheme(this.getScheme());
        }
        if (this.getUserInfo() != null) {
            builder.userInfo(this.getUserInfo());
        }
        if (this.getHost() != null) {
            builder.host(this.getHost());
        }
        if (this.port != null) {
            builder.port(this.port);
        }
        this.path.copyToUriComponentsBuilder(builder);
        if (!this.getQueryParams().isEmpty()) {
            builder.queryParams((MultiValueMap)this.getQueryParams());
        }
        if (this.getFragment() != null) {
            builder.fragment(this.getFragment());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HierarchicalUriComponents)) {
            return false;
        }
        HierarchicalUriComponents other = (HierarchicalUriComponents)obj;
        return ObjectUtils.nullSafeEquals((Object)this.getScheme(), (Object)other.getScheme()) && ObjectUtils.nullSafeEquals((Object)this.getUserInfo(), (Object)other.getUserInfo()) && ObjectUtils.nullSafeEquals((Object)this.getHost(), (Object)other.getHost()) && this.getPort() == other.getPort() && this.path.equals(other.path) && this.queryParams.equals(other.queryParams) && ObjectUtils.nullSafeEquals((Object)this.getFragment(), (Object)other.getFragment());
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.getScheme());
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.userInfo);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.host);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.port);
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.queryParams.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.getFragment());
        return result;
    }

    private static class QueryUriTemplateVariables
    implements UriComponents.UriTemplateVariables {
        private final UriComponents.UriTemplateVariables delegate;

        public QueryUriTemplateVariables(UriComponents.UriTemplateVariables delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object getValue(@Nullable String name) {
            Object value = this.delegate.getValue(name);
            if (ObjectUtils.isArray((Object)value)) {
                value = StringUtils.arrayToCommaDelimitedString((Object[])ObjectUtils.toObjectArray((Object)value));
            }
            return value;
        }
    }

    static final class PathComponentComposite
    implements PathComponent {
        private final List<PathComponent> pathComponents;

        public PathComponentComposite(List<PathComponent> pathComponents) {
            Assert.notNull(pathComponents, (String)"PathComponent List must not be null");
            this.pathComponents = pathComponents;
        }

        @Override
        public String getPath() {
            StringBuilder pathBuilder = new StringBuilder();
            for (PathComponent pathComponent : this.pathComponents) {
                pathBuilder.append(pathComponent.getPath());
            }
            return pathBuilder.toString();
        }

        @Override
        public List<String> getPathSegments() {
            ArrayList<String> result = new ArrayList<String>();
            for (PathComponent pathComponent : this.pathComponents) {
                result.addAll(pathComponent.getPathSegments());
            }
            return result;
        }

        @Override
        public PathComponent encode(Charset charset) {
            ArrayList<PathComponent> encodedComponents = new ArrayList<PathComponent>(this.pathComponents.size());
            for (PathComponent pathComponent : this.pathComponents) {
                encodedComponents.add(pathComponent.encode(charset));
            }
            return new PathComponentComposite(encodedComponents);
        }

        @Override
        public void verify() {
            for (PathComponent pathComponent : this.pathComponents) {
                pathComponent.verify();
            }
        }

        @Override
        public PathComponent expand(UriComponents.UriTemplateVariables uriVariables) {
            ArrayList<PathComponent> expandedComponents = new ArrayList<PathComponent>(this.pathComponents.size());
            for (PathComponent pathComponent : this.pathComponents) {
                expandedComponents.add(pathComponent.expand(uriVariables));
            }
            return new PathComponentComposite(expandedComponents);
        }

        @Override
        public void copyToUriComponentsBuilder(UriComponentsBuilder builder) {
            for (PathComponent pathComponent : this.pathComponents) {
                pathComponent.copyToUriComponentsBuilder(builder);
            }
        }
    }

    static final class PathSegmentComponent
    implements PathComponent {
        private final List<String> pathSegments;

        public PathSegmentComponent(List<String> pathSegments) {
            Assert.notNull(pathSegments, (String)"List must not be null");
            this.pathSegments = Collections.unmodifiableList(new ArrayList<String>(pathSegments));
        }

        @Override
        public String getPath() {
            StringBuilder pathBuilder = new StringBuilder();
            pathBuilder.append('/');
            Iterator<String> iterator = this.pathSegments.iterator();
            while (iterator.hasNext()) {
                String pathSegment = iterator.next();
                pathBuilder.append(pathSegment);
                if (!iterator.hasNext()) continue;
                pathBuilder.append('/');
            }
            return pathBuilder.toString();
        }

        @Override
        public List<String> getPathSegments() {
            return this.pathSegments;
        }

        @Override
        public PathComponent encode(Charset charset) {
            List<String> pathSegments = this.getPathSegments();
            ArrayList<String> encodedPathSegments = new ArrayList<String>(pathSegments.size());
            for (String pathSegment : pathSegments) {
                String encodedPathSegment = HierarchicalUriComponents.encodeUriComponent(pathSegment, charset, Type.PATH_SEGMENT);
                encodedPathSegments.add(encodedPathSegment);
            }
            return new PathSegmentComponent(encodedPathSegments);
        }

        @Override
        public void verify() {
            for (String pathSegment : this.getPathSegments()) {
                HierarchicalUriComponents.verifyUriComponent(pathSegment, Type.PATH_SEGMENT);
            }
        }

        @Override
        public PathComponent expand(UriComponents.UriTemplateVariables uriVariables) {
            List<String> pathSegments = this.getPathSegments();
            ArrayList<String> expandedPathSegments = new ArrayList<String>(pathSegments.size());
            for (String pathSegment : pathSegments) {
                String expandedPathSegment = UriComponents.expandUriComponent(pathSegment, uriVariables);
                expandedPathSegments.add(expandedPathSegment);
            }
            return new PathSegmentComponent(expandedPathSegments);
        }

        @Override
        public void copyToUriComponentsBuilder(UriComponentsBuilder builder) {
            builder.pathSegment(this.getPathSegments().toArray(new String[this.getPathSegments().size()]));
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof PathSegmentComponent && this.getPathSegments().equals(((PathSegmentComponent)obj).getPathSegments());
        }

        public int hashCode() {
            return this.getPathSegments().hashCode();
        }
    }

    static final class FullPathComponent
    implements PathComponent {
        private final String path;

        public FullPathComponent(@Nullable String path) {
            this.path = path != null ? path : "";
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public List<String> getPathSegments() {
            String[] segments = StringUtils.tokenizeToStringArray((String)this.path, (String)HierarchicalUriComponents.PATH_DELIMITER_STRING);
            return Collections.unmodifiableList(Arrays.asList(segments));
        }

        @Override
        public PathComponent encode(Charset charset) {
            String encodedPath = HierarchicalUriComponents.encodeUriComponent(this.getPath(), charset, Type.PATH);
            return new FullPathComponent(encodedPath);
        }

        @Override
        public void verify() {
            HierarchicalUriComponents.verifyUriComponent(this.path, Type.PATH);
        }

        @Override
        public PathComponent expand(UriComponents.UriTemplateVariables uriVariables) {
            String expandedPath = UriComponents.expandUriComponent(this.getPath(), uriVariables);
            return new FullPathComponent(expandedPath);
        }

        @Override
        public void copyToUriComponentsBuilder(UriComponentsBuilder builder) {
            builder.path(this.getPath());
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof FullPathComponent && this.getPath().equals(((FullPathComponent)obj).getPath());
        }

        public int hashCode() {
            return this.getPath().hashCode();
        }
    }

    static interface PathComponent
    extends Serializable {
        public String getPath();

        public List<String> getPathSegments();

        public PathComponent encode(Charset var1);

        public void verify();

        public PathComponent expand(UriComponents.UriTemplateVariables var1);

        public void copyToUriComponentsBuilder(UriComponentsBuilder var1);
    }

    static enum Type {
        SCHEME{

            @Override
            public boolean isAllowed(int c) {
                return this.isAlpha(c) || this.isDigit(c) || 43 == c || 45 == c || 46 == c;
            }
        }
        ,
        AUTHORITY{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c || 64 == c;
            }
        }
        ,
        USER_INFO{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c;
            }
        }
        ,
        HOST_IPV4{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c);
            }
        }
        ,
        HOST_IPV6{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c) || this.isSubDelimiter(c) || 91 == c || 93 == c || 58 == c;
            }
        }
        ,
        PORT{

            @Override
            public boolean isAllowed(int c) {
                return this.isDigit(c);
            }
        }
        ,
        PATH{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c;
            }
        }
        ,
        PATH_SEGMENT{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c);
            }
        }
        ,
        QUERY{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        QUERY_PARAM{

            @Override
            public boolean isAllowed(int c) {
                if (61 == c || 38 == c) {
                    return false;
                }
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        FRAGMENT{

            @Override
            public boolean isAllowed(int c) {
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        URI{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c);
            }
        };


        public abstract boolean isAllowed(int var1);

        protected boolean isAlpha(int c) {
            return c >= 97 && c <= 122 || c >= 65 && c <= 90;
        }

        protected boolean isDigit(int c) {
            return c >= 48 && c <= 57;
        }

        protected boolean isGenericDelimiter(int c) {
            return 58 == c || 47 == c || 63 == c || 35 == c || 91 == c || 93 == c || 64 == c;
        }

        protected boolean isSubDelimiter(int c) {
            return 33 == c || 36 == c || 38 == c || 39 == c || 40 == c || 41 == c || 42 == c || 43 == c || 44 == c || 59 == c || 61 == c;
        }

        protected boolean isReserved(int c) {
            return this.isGenericDelimiter(c) || this.isSubDelimiter(c);
        }

        protected boolean isUnreserved(int c) {
            return this.isAlpha(c) || this.isDigit(c) || 45 == c || 46 == c || 95 == c || 126 == c;
        }

        protected boolean isPchar(int c) {
            return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c || 64 == c;
        }
    }
}

