/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.pattern.PathElement;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.SubSequence;

class CaptureVariablePathElement
extends PathElement {
    private final String variableName;
    private Pattern constraintPattern;

    CaptureVariablePathElement(int pos, char[] captureDescriptor, boolean caseSensitive, char separator) {
        super(pos, separator);
        int colon = -1;
        for (int i = 0; i < captureDescriptor.length; ++i) {
            if (captureDescriptor[i] != ':') continue;
            colon = i;
            break;
        }
        if (colon == -1) {
            this.variableName = new String(captureDescriptor, 1, captureDescriptor.length - 2);
        } else {
            this.variableName = new String(captureDescriptor, 1, colon - 1);
            this.constraintPattern = caseSensitive ? Pattern.compile(new String(captureDescriptor, colon + 1, captureDescriptor.length - colon - 2)) : Pattern.compile(new String(captureDescriptor, colon + 1, captureDescriptor.length - colon - 2), 2);
        }
    }

    @Override
    public boolean matches(int candidateIndex, PathPattern.MatchingContext matchingContext) {
        int nextPos = matchingContext.scanAhead(candidateIndex);
        if (nextPos == candidateIndex) {
            return false;
        }
        String substringForDecoding = null;
        CharSequence candidateCapture = null;
        if (this.constraintPattern != null) {
            if (this.includesPercent(matchingContext.candidate, candidateIndex, nextPos)) {
                substringForDecoding = new String(matchingContext.candidate, candidateIndex, nextPos);
                candidateCapture = UriUtils.decode(substringForDecoding, StandardCharsets.UTF_8);
            } else {
                candidateCapture = new SubSequence(matchingContext.candidate, candidateIndex, nextPos);
            }
            Matcher matcher = this.constraintPattern.matcher(candidateCapture);
            if (matcher.groupCount() != 0) {
                throw new IllegalArgumentException("No capture groups allowed in the constraint regex: " + this.constraintPattern.pattern());
            }
            if (!matcher.matches()) {
                return false;
            }
        }
        boolean match = false;
        if (this.next == null) {
            if (matchingContext.determineRemainingPath && nextPos > candidateIndex) {
                matchingContext.remainingPathIndex = nextPos;
                match = true;
            } else {
                boolean bl = match = nextPos == matchingContext.candidateLength && nextPos > candidateIndex;
                if (!match && matchingContext.isAllowOptionalTrailingSlash()) {
                    match = nextPos > candidateIndex && nextPos + 1 == matchingContext.candidateLength && matchingContext.candidate[nextPos] == this.separator;
                }
            }
        } else {
            match = matchingContext.isMatchStartMatching && nextPos == matchingContext.candidateLength ? true : this.next.matches(nextPos, matchingContext);
        }
        if (match && matchingContext.extractingVariables) {
            matchingContext.set(this.variableName, candidateCapture != null ? candidateCapture.toString() : this.decode(new String(matchingContext.candidate, candidateIndex, nextPos - candidateIndex)));
        }
        return match;
    }

    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public int getNormalizedLength() {
        return 1;
    }

    @Override
    public int getWildcardCount() {
        return 0;
    }

    @Override
    public int getCaptureCount() {
        return 1;
    }

    @Override
    public int getScore() {
        return 1;
    }

    public String toString() {
        return "CaptureVariable({" + this.variableName + (this.constraintPattern != null ? ":" + this.constraintPattern.pattern() : "") + "})";
    }
}

