/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import java.nio.charset.StandardCharsets;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.pattern.PathPattern;

abstract class PathElement {
    protected static final int WILDCARD_WEIGHT = 100;
    protected static final int CAPTURE_VARIABLE_WEIGHT = 1;
    protected final int pos;
    protected final char separator;
    protected PathElement next;
    protected PathElement prev;

    PathElement(int pos, char separator) {
        this.pos = pos;
        this.separator = separator;
    }

    public abstract boolean matches(int var1, PathPattern.MatchingContext var2);

    public abstract int getNormalizedLength();

    public int getCaptureCount() {
        return 0;
    }

    public int getWildcardCount() {
        return 0;
    }

    public int getScore() {
        return 0;
    }

    protected boolean nextIfExistsIsSeparator(int nextIndex, PathPattern.MatchingContext matchingContext) {
        return nextIndex >= matchingContext.candidateLength || matchingContext.candidate[nextIndex] == this.separator;
    }

    protected String decode(CharSequence toDecode) {
        CharSequence decoded = toDecode;
        if (this.includesPercent(toDecode)) {
            decoded = UriUtils.decode(toDecode.toString(), StandardCharsets.UTF_8);
        }
        return decoded.toString();
    }

    protected boolean includesPercent(char[] chars, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (chars[i] != '%') continue;
            return true;
        }
        return false;
    }

    protected boolean includesPercent(CharSequence chars) {
        int max = chars.length();
        for (int i = 0; i < max; ++i) {
            if (chars.charAt(i) != '%') continue;
            return true;
        }
        return false;
    }
}

