/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.pattern.PathElement;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PatternParseException;
import org.springframework.web.util.pattern.SubSequence;

class RegexPathElement
extends PathElement {
    private final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*|\\{((?:\\{[^/]+?\\}|[^/{}]|\\\\[{}])+?)\\}");
    private final String DEFAULT_VARIABLE_PATTERN = "(.*)";
    private char[] regex;
    private final boolean caseSensitive;
    private final Pattern pattern;
    private int wildcardCount;
    private final List<String> variableNames = new LinkedList<String>();

    RegexPathElement(int pos, char[] regex, boolean caseSensitive, char[] completePattern, char separator) {
        super(pos, separator);
        this.regex = regex;
        this.caseSensitive = caseSensitive;
        this.pattern = this.buildPattern(regex, completePattern);
    }

    public Pattern buildPattern(char[] regex, char[] completePattern) {
        StringBuilder patternBuilder = new StringBuilder();
        String text = new String(regex);
        StringBuilder encodedRegexBuilder = new StringBuilder();
        Matcher matcher = this.GLOB_PATTERN.matcher(text);
        int end = 0;
        while (matcher.find()) {
            patternBuilder.append(this.quote(text, end, matcher.start(), encodedRegexBuilder));
            String match = matcher.group();
            if ("?".equals(match)) {
                patternBuilder.append('.');
                encodedRegexBuilder.append('?');
            } else if ("*".equals(match)) {
                patternBuilder.append(".*");
                encodedRegexBuilder.append('*');
                int pos = matcher.start();
                if (pos < 1 || text.charAt(pos - 1) != '.') {
                    ++this.wildcardCount;
                }
            } else if (match.startsWith("{") && match.endsWith("}")) {
                encodedRegexBuilder.append(match);
                int colonIdx = match.indexOf(58);
                if (colonIdx == -1) {
                    patternBuilder.append("(.*)");
                    String variableName = matcher.group(1);
                    if (this.variableNames.contains(variableName)) {
                        throw new PatternParseException(this.pos, completePattern, PatternParseException.PatternMessage.ILLEGAL_DOUBLE_CAPTURE, variableName);
                    }
                    this.variableNames.add(variableName);
                } else {
                    String variablePattern = match.substring(colonIdx + 1, match.length() - 1);
                    patternBuilder.append('(');
                    patternBuilder.append(variablePattern);
                    patternBuilder.append(')');
                    String variableName = match.substring(1, colonIdx);
                    if (this.variableNames.contains(variableName)) {
                        throw new PatternParseException(this.pos, completePattern, PatternParseException.PatternMessage.ILLEGAL_DOUBLE_CAPTURE, variableName);
                    }
                    this.variableNames.add(variableName);
                }
            }
            end = matcher.end();
        }
        patternBuilder.append(this.quote(text, end, text.length(), encodedRegexBuilder));
        this.regex = encodedRegexBuilder.toString().toCharArray();
        if (this.caseSensitive) {
            return Pattern.compile(patternBuilder.toString());
        }
        return Pattern.compile(patternBuilder.toString(), 2);
    }

    public List<String> getVariableNames() {
        return this.variableNames;
    }

    private String quote(String s, int start, int end, StringBuilder encodedRegexBuilder) {
        if (start == end) {
            return "";
        }
        String substring = s.substring(start, end);
        String encodedSubString = UriUtils.encodePath(substring, StandardCharsets.UTF_8);
        encodedRegexBuilder.append(encodedSubString);
        return Pattern.quote(substring);
    }

    @Override
    public boolean matches(int candidateIndex, PathPattern.MatchingContext matchingContext) {
        int pos = matchingContext.scanAhead(candidateIndex);
        CharSequence textToMatch = null;
        textToMatch = this.includesPercent(matchingContext.candidate, candidateIndex, pos) ? this.decode(new SubSequence(matchingContext.candidate, candidateIndex, pos)) : new SubSequence(matchingContext.candidate, candidateIndex, pos);
        Matcher matcher = this.pattern.matcher(textToMatch);
        boolean matches = matcher.matches();
        if (matches) {
            if (this.next == null) {
                if (matchingContext.determineRemainingPath && (this.variableNames.size() == 0 || pos > candidateIndex)) {
                    matchingContext.remainingPathIndex = pos;
                    matches = true;
                } else {
                    boolean bl = matches = pos == matchingContext.candidateLength && (this.variableNames.size() == 0 || pos > candidateIndex);
                    if (!matches && matchingContext.isAllowOptionalTrailingSlash()) {
                        matches = (this.variableNames.size() == 0 || pos > candidateIndex) && pos + 1 == matchingContext.candidateLength && matchingContext.candidate[pos] == this.separator;
                    }
                }
            } else {
                if (matchingContext.isMatchStartMatching && pos == matchingContext.candidateLength) {
                    return true;
                }
                matches = this.next.matches(pos, matchingContext);
            }
        }
        if (matches && matchingContext.extractingVariables) {
            if (this.variableNames.size() != matcher.groupCount()) {
                throw new IllegalArgumentException("The number of capturing groups in the pattern segment " + this.pattern + " does not match the number of URI template variables it defines, which can occur if capturing groups are used in a URI template regex. Use non-capturing groups instead.");
            }
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String name = this.variableNames.get(i - 1);
                String value = matcher.group(i);
                matchingContext.set(name, value);
            }
        }
        return matches;
    }

    @Override
    public int getNormalizedLength() {
        int varsLength = 0;
        for (String variableName : this.variableNames) {
            varsLength += variableName.length();
        }
        return this.regex.length - varsLength - this.variableNames.size();
    }

    @Override
    public int getCaptureCount() {
        return this.variableNames.size();
    }

    @Override
    public int getWildcardCount() {
        return this.wildcardCount;
    }

    @Override
    public int getScore() {
        return this.getCaptureCount() * 1 + this.getWildcardCount() * 100;
    }

    public String toString() {
        return "Regex(" + String.valueOf(this.regex) + ")";
    }
}

