/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import org.springframework.web.util.pattern.PathElement;
import org.springframework.web.util.pattern.PathPattern;

class SeparatorPathElement
extends PathElement {
    SeparatorPathElement(int pos, char separator) {
        super(pos, separator);
    }

    @Override
    public boolean matches(int candidateIndex, PathPattern.MatchingContext matchingContext) {
        boolean matched = false;
        if (candidateIndex < matchingContext.candidateLength && matchingContext.candidate[candidateIndex] == this.separator) {
            if (this.next == null) {
                if (matchingContext.determineRemainingPath) {
                    matchingContext.remainingPathIndex = candidateIndex + 1;
                    matched = true;
                } else {
                    matched = candidateIndex + 1 == matchingContext.candidateLength;
                }
            } else {
                if (matchingContext.isMatchStartMatching && ++candidateIndex == matchingContext.candidateLength) {
                    return true;
                }
                matched = this.next.matches(candidateIndex, matchingContext);
            }
        }
        return matched;
    }

    @Override
    public int getNormalizedLength() {
        return 1;
    }

    public String toString() {
        return "Separator(" + this.separator + ")";
    }
}

