/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import org.springframework.web.util.pattern.PathElement;
import org.springframework.web.util.pattern.PathPattern;

class WildcardPathElement
extends PathElement {
    public WildcardPathElement(int pos, char separator) {
        super(pos, separator);
    }

    @Override
    public boolean matches(int candidateIndex, PathPattern.MatchingContext matchingContext) {
        int nextPos = matchingContext.scanAhead(candidateIndex);
        if (this.next == null) {
            if (matchingContext.determineRemainingPath) {
                matchingContext.remainingPathIndex = nextPos;
                return true;
            }
            if (nextPos == matchingContext.candidateLength) {
                return true;
            }
            return matchingContext.isAllowOptionalTrailingSlash() && nextPos > candidateIndex && nextPos + 1 == matchingContext.candidateLength && matchingContext.candidate[nextPos] == this.separator;
        }
        if (matchingContext.isMatchStartMatching && nextPos == matchingContext.candidateLength) {
            return true;
        }
        if (nextPos == candidateIndex) {
            return false;
        }
        return this.next.matches(nextPos, matchingContext);
    }

    @Override
    public int getNormalizedLength() {
        return 1;
    }

    @Override
    public int getWildcardCount() {
        return 1;
    }

    @Override
    public int getScore() {
        return 100;
    }

    public String toString() {
        return "Wildcard(*)";
    }
}

