/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.net.URI;
import java.util.List;
import org.springframework.http.server.reactive.PathContainer;
import org.springframework.http.server.reactive.RequestPath;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class DefaultRequestPath
implements RequestPath {
    private final PathContainer fullPath;
    private final PathContainer contextPath;
    private final PathContainer pathWithinApplication;

    DefaultRequestPath(URI uri, @Nullable String contextPath) {
        this.fullPath = PathContainer.parseUrlPath(uri.getRawPath());
        this.contextPath = DefaultRequestPath.initContextPath(this.fullPath, contextPath);
        this.pathWithinApplication = DefaultRequestPath.extractPathWithinApplication(this.fullPath, this.contextPath);
    }

    DefaultRequestPath(RequestPath requestPath, @Nullable String contextPath) {
        this.fullPath = requestPath;
        this.contextPath = DefaultRequestPath.initContextPath(this.fullPath, contextPath);
        this.pathWithinApplication = DefaultRequestPath.extractPathWithinApplication(this.fullPath, this.contextPath);
    }

    private static PathContainer initContextPath(PathContainer path, @Nullable String contextPath) {
        if (!StringUtils.hasText((String)contextPath) || "/".equals(contextPath)) {
            return PathContainer.parseUrlPath("");
        }
        Assert.isTrue((contextPath.startsWith("/") && !contextPath.endsWith("/") && path.value().startsWith(contextPath) ? 1 : 0) != 0, (String)("Invalid contextPath: " + contextPath));
        int length = contextPath.length();
        int counter = 0;
        for (int i = 0; i < path.elements().size(); ++i) {
            PathContainer.Element element = path.elements().get(i);
            if (length != (counter += element.value().length())) continue;
            return path.subPath(0, i + 1);
        }
        throw new IllegalStateException("Failed to initialize contextPath='" + contextPath + "' given path='" + path.value() + "'");
    }

    private static PathContainer extractPathWithinApplication(PathContainer fullPath, PathContainer contextPath) {
        return fullPath.subPath(contextPath.elements().size());
    }

    @Override
    public String value() {
        return this.fullPath.value();
    }

    @Override
    public List<PathContainer.Element> elements() {
        return this.fullPath.elements();
    }

    @Override
    public PathContainer contextPath() {
        return this.contextPath;
    }

    @Override
    public PathContainer pathWithinApplication() {
        return this.pathWithinApplication;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DefaultRequestPath that = (DefaultRequestPath)other;
        return this.fullPath.equals(that.fullPath) && this.contextPath.equals(that.contextPath) && this.pathWithinApplication.equals(that.pathWithinApplication);
    }

    public int hashCode() {
        int result = this.fullPath.hashCode();
        result = 31 * result + this.contextPath.hashCode();
        result = 31 * result + this.pathWithinApplication.hashCode();
        return result;
    }

    public String toString() {
        return "DefaultRequestPath[fullPath='" + this.fullPath + "', contextPath='" + this.contextPath.value() + "', pathWithinApplication='" + this.pathWithinApplication.value() + "']";
    }
}

