/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.session;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.util.Assert;
import org.springframework.util.IdGenerator;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

class DefaultWebSession
implements WebSession {
    private final AtomicReference<String> id;
    private final IdGenerator idGenerator;
    private final Map<String, Object> attributes;
    private final Clock clock;
    private final BiFunction<String, WebSession, Mono<Void>> changeIdOperation;
    private final Function<WebSession, Mono<Void>> saveOperation;
    private final Instant creationTime;
    private final Instant lastAccessTime;
    private volatile Duration maxIdleTime;
    private volatile State state;

    DefaultWebSession(IdGenerator idGenerator, Clock clock, BiFunction<String, WebSession, Mono<Void>> changeIdOperation, Function<WebSession, Mono<Void>> saveOperation) {
        Assert.notNull((Object)idGenerator, (String)"'idGenerator' is required.");
        Assert.notNull((Object)clock, (String)"'clock' is required.");
        Assert.notNull(changeIdOperation, (String)"'changeIdOperation' is required.");
        Assert.notNull(saveOperation, (String)"'saveOperation' is required.");
        this.id = new AtomicReference<String>(String.valueOf(idGenerator.generateId()));
        this.idGenerator = idGenerator;
        this.clock = clock;
        this.changeIdOperation = changeIdOperation;
        this.saveOperation = saveOperation;
        this.attributes = new ConcurrentHashMap<String, Object>();
        this.lastAccessTime = this.creationTime = Instant.now(clock);
        this.maxIdleTime = Duration.ofMinutes(30L);
        this.state = State.NEW;
    }

    DefaultWebSession(DefaultWebSession existingSession, Instant lastAccessTime, Function<WebSession, Mono<Void>> saveOperation) {
        this.id = existingSession.id;
        this.idGenerator = existingSession.idGenerator;
        this.attributes = existingSession.attributes;
        this.clock = existingSession.clock;
        this.changeIdOperation = existingSession.changeIdOperation;
        this.saveOperation = saveOperation;
        this.creationTime = existingSession.creationTime;
        this.lastAccessTime = lastAccessTime;
        this.maxIdleTime = existingSession.maxIdleTime;
        this.state = existingSession.state;
    }

    DefaultWebSession(DefaultWebSession existingSession, Instant lastAccessTime) {
        this.id = existingSession.id;
        this.idGenerator = existingSession.idGenerator;
        this.attributes = existingSession.attributes;
        this.clock = existingSession.clock;
        this.changeIdOperation = existingSession.changeIdOperation;
        this.saveOperation = existingSession.saveOperation;
        this.creationTime = existingSession.creationTime;
        this.lastAccessTime = lastAccessTime;
        this.maxIdleTime = existingSession.maxIdleTime;
        this.state = existingSession.state;
    }

    @Override
    public String getId() {
        return this.id.get();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Instant getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void setMaxIdleTime(Duration maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public Duration getMaxIdleTime() {
        return this.maxIdleTime;
    }

    @Override
    public void start() {
        this.state = State.STARTED;
    }

    @Override
    public boolean isStarted() {
        State value = this.state;
        return State.STARTED.equals((Object)value) || State.NEW.equals((Object)value) && !this.getAttributes().isEmpty();
    }

    @Override
    public Mono<Void> changeSessionId() {
        String oldId = this.id.get();
        String newId = String.valueOf(this.idGenerator.generateId());
        this.id.set(newId);
        return this.changeIdOperation.apply(oldId, this).doOnError(ex -> this.id.set(oldId));
    }

    @Override
    public Mono<Void> save() {
        return this.saveOperation.apply(this);
    }

    @Override
    public boolean isExpired() {
        return this.isStarted() && !this.maxIdleTime.isNegative() && Instant.now(this.clock).minus(this.maxIdleTime).isAfter(this.lastAccessTime);
    }

    private static enum State {
        NEW,
        STARTED;

    }
}

