/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.session;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.IdGenerator;
import org.springframework.util.JdkIdGenerator;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.springframework.web.server.session.CookieWebSessionIdResolver;
import org.springframework.web.server.session.DefaultWebSession;
import org.springframework.web.server.session.InMemoryWebSessionStore;
import org.springframework.web.server.session.WebSessionIdResolver;
import org.springframework.web.server.session.WebSessionManager;
import org.springframework.web.server.session.WebSessionStore;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultWebSessionManager
implements WebSessionManager {
    private static final IdGenerator idGenerator = new JdkIdGenerator();
    private WebSessionIdResolver sessionIdResolver = new CookieWebSessionIdResolver();
    private WebSessionStore sessionStore = new InMemoryWebSessionStore();
    private Clock clock = Clock.system(ZoneId.of("GMT"));

    public void setSessionIdResolver(WebSessionIdResolver sessionIdResolver) {
        Assert.notNull((Object)sessionIdResolver, (String)"WebSessionIdResolver is required.");
        this.sessionIdResolver = sessionIdResolver;
    }

    public WebSessionIdResolver getSessionIdResolver() {
        return this.sessionIdResolver;
    }

    public void setSessionStore(WebSessionStore sessionStore) {
        Assert.notNull((Object)sessionStore, (String)"WebSessionStore is required.");
        this.sessionStore = sessionStore;
    }

    public WebSessionStore getSessionStore() {
        return this.sessionStore;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"'clock' is required.");
        this.clock = clock;
    }

    public Clock getClock() {
        return this.clock;
    }

    @Override
    public Mono<WebSession> getSession(ServerWebExchange exchange) {
        return Mono.defer(() -> this.retrieveSession(exchange).flatMap(session -> this.removeSessionIfExpired(exchange, (DefaultWebSession)session)).map(session -> {
            Instant lastAccessTime = Instant.now(this.getClock());
            return new DefaultWebSession((DefaultWebSession)session, lastAccessTime, s -> this.saveSession(exchange, (WebSession)s));
        }).switchIfEmpty(this.createSession(exchange)).doOnNext(session -> exchange.getResponse().beforeCommit(session::save)));
    }

    private Mono<DefaultWebSession> retrieveSession(ServerWebExchange exchange) {
        return Flux.fromIterable(this.getSessionIdResolver().resolveSessionIds(exchange)).concatMap(this.sessionStore::retrieveSession).cast(DefaultWebSession.class).next();
    }

    private Mono<DefaultWebSession> removeSessionIfExpired(ServerWebExchange exchange, DefaultWebSession session) {
        if (session.isExpired()) {
            this.sessionIdResolver.expireSession(exchange);
            return this.sessionStore.removeSession(session.getId()).then(Mono.empty());
        }
        return Mono.just((Object)session);
    }

    private Mono<Void> saveSession(ServerWebExchange exchange, WebSession session) {
        if (session.isExpired()) {
            return Mono.error((Throwable)new IllegalStateException("Sessions are checked for expiration and have their lastAccessTime updated when first accessed during request processing. However this session is expired meaning that maxIdleTime elapsed before the call to session.save()."));
        }
        if (!session.isStarted()) {
            return Mono.empty();
        }
        session.start();
        if (this.hasNewSessionId(exchange, session)) {
            this.sessionIdResolver.setSessionId(exchange, session.getId());
        }
        return this.sessionStore.storeSession(session);
    }

    private boolean hasNewSessionId(ServerWebExchange exchange, WebSession session) {
        List<String> ids = this.getSessionIdResolver().resolveSessionIds(exchange);
        return ids.isEmpty() || !session.getId().equals(ids.get(0));
    }

    private Mono<DefaultWebSession> createSession(ServerWebExchange exchange) {
        return Mono.fromSupplier(() -> new DefaultWebSession(idGenerator, this.getClock(), (oldId, session) -> this.sessionStore.changeSessionId((String)oldId, (WebSession)session), session -> this.saveSession(exchange, (WebSession)session)));
    }
}

