/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.support;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.support.BaseDefaultCodecs;
import org.springframework.util.Assert;

abstract class BaseCodecConfigurer
implements CodecConfigurer {
    protected boolean customCodecsInitialized;
    protected final BaseDefaultCodecs defaultCodecs;
    protected final DefaultCustomCodecs customCodecs;

    BaseCodecConfigurer(BaseDefaultCodecs defaultCodecs) {
        Assert.notNull((Object)defaultCodecs, (String)"'defaultCodecs' is required");
        this.defaultCodecs = defaultCodecs;
        this.customCodecs = new DefaultCustomCodecs();
    }

    protected BaseCodecConfigurer(BaseCodecConfigurer other) {
        this.defaultCodecs = other.cloneDefaultCodecs();
        this.customCodecs = new DefaultCustomCodecs(other.customCodecs);
    }

    protected abstract BaseDefaultCodecs cloneDefaultCodecs();

    @Override
    public CodecConfigurer.DefaultCodecs defaultCodecs() {
        return this.defaultCodecs;
    }

    @Override
    public void registerDefaults(boolean shouldRegister) {
        this.defaultCodecs.registerDefaults(shouldRegister);
    }

    @Override
    public CodecConfigurer.CustomCodecs customCodecs() {
        return this.customCodecs;
    }

    @Override
    public List<HttpMessageReader<?>> getReaders() {
        this.initializeCustomCodecs();
        ArrayList result = new ArrayList();
        result.addAll(this.defaultCodecs.getTypedReaders());
        result.addAll(this.customCodecs.getTypedReaders());
        result.addAll(this.defaultCodecs.getObjectReaders());
        result.addAll(this.customCodecs.getObjectReaders());
        result.addAll(this.defaultCodecs.getCatchAllReaders());
        return result;
    }

    @Override
    public List<HttpMessageWriter<?>> getWriters() {
        return this.getWritersInternal(false);
    }

    protected List<HttpMessageWriter<?>> getWritersInternal(boolean forMultipart) {
        this.initializeCustomCodecs();
        ArrayList result = new ArrayList();
        result.addAll(this.defaultCodecs.getTypedWriters(forMultipart));
        result.addAll(this.customCodecs.getTypedWriters());
        result.addAll(this.defaultCodecs.getObjectWriters(forMultipart));
        result.addAll(this.customCodecs.getObjectWriters());
        result.addAll(this.defaultCodecs.getCatchAllWriters());
        return result;
    }

    @Override
    public abstract CodecConfigurer clone();

    private void initializeCustomCodecs() {
        if (!this.customCodecsInitialized) {
            this.customCodecs.configConsumers.forEach(consumer -> consumer.accept(this.defaultCodecs));
            this.customCodecsInitialized = true;
        }
    }

    protected static final class DefaultCustomCodecs
    implements CodecConfigurer.CustomCodecs {
        private final List<HttpMessageReader<?>> typedReaders = new ArrayList();
        private final List<HttpMessageWriter<?>> typedWriters = new ArrayList();
        private final List<HttpMessageReader<?>> objectReaders = new ArrayList();
        private final List<HttpMessageWriter<?>> objectWriters = new ArrayList();
        private final List<Consumer<CodecConfigurer.DefaultCodecConfig>> configConsumers = new ArrayList<Consumer<CodecConfigurer.DefaultCodecConfig>>();

        DefaultCustomCodecs() {
        }

        DefaultCustomCodecs(DefaultCustomCodecs other) {
            other.typedReaders.addAll(this.typedReaders);
            other.typedWriters.addAll(this.typedWriters);
            other.objectReaders.addAll(this.objectReaders);
            other.objectWriters.addAll(this.objectWriters);
        }

        @Override
        public void decoder(Decoder<?> decoder) {
            this.reader(new DecoderHttpMessageReader(decoder));
        }

        @Override
        public void encoder(Encoder<?> encoder) {
            this.writer(new EncoderHttpMessageWriter(encoder));
        }

        @Override
        public void reader(HttpMessageReader<?> reader) {
            boolean canReadToObject = reader.canRead(ResolvableType.forClass(Object.class), null);
            (canReadToObject ? this.objectReaders : this.typedReaders).add(reader);
        }

        @Override
        public void writer(HttpMessageWriter<?> writer) {
            boolean canWriteObject = writer.canWrite(ResolvableType.forClass(Object.class), null);
            (canWriteObject ? this.objectWriters : this.typedWriters).add(writer);
        }

        @Override
        public void withDefaultCodecConfig(Consumer<CodecConfigurer.DefaultCodecConfig> codecsConfigConsumer) {
            this.configConsumers.add(codecsConfigConsumer);
        }

        List<HttpMessageReader<?>> getTypedReaders() {
            return this.typedReaders;
        }

        List<HttpMessageWriter<?>> getTypedWriters() {
            return this.typedWriters;
        }

        List<HttpMessageReader<?>> getObjectReaders() {
            return this.objectReaders;
        }

        List<HttpMessageWriter<?>> getObjectWriters() {
            return this.objectWriters;
        }
    }
}

