/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder.xml;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.definition.registry.FlowDefinitionResource;
import org.springframework.webflow.engine.builder.AbstractFlowBuildingFlowRegistryFactoryBean;
import org.springframework.webflow.engine.builder.FlowServiceLocator;
import org.springframework.webflow.engine.builder.xml.DocumentLoader;
import org.springframework.webflow.engine.builder.xml.XmlFlowRegistrar;

public class XmlFlowRegistryFactoryBean
extends AbstractFlowBuildingFlowRegistryFactoryBean {
    private XmlFlowRegistrar flowRegistrar = new XmlFlowRegistrar();
    private Resource[] locations;
    private Properties flowDefinitions;
    private Map flowAttributes;

    public XmlFlowRegistrar getXmlFlowRegistrar() {
        return this.flowRegistrar;
    }

    public void setXmlFlowRegistrar(XmlFlowRegistrar flowRegistrar) {
        Assert.notNull((Object)flowRegistrar, (String)"The flowRegistrar is required");
        this.flowRegistrar = flowRegistrar;
    }

    public void setFlowLocations(Resource[] locations) {
        this.locations = locations;
    }

    public void setFlowDefinitions(Properties flowDefinitions) {
        this.flowDefinitions = flowDefinitions;
    }

    public void setFlowAttributes(Map flowAttributes) {
        this.flowAttributes = flowAttributes;
    }

    public void setDocumentLoader(DocumentLoader documentLoader) {
        this.getXmlFlowRegistrar().setDocumentLoader(documentLoader);
    }

    protected void init(FlowServiceLocator flowServiceLocator) {
        this.getXmlFlowRegistrar().setFlowServiceLocator(flowServiceLocator);
    }

    protected void doPopulate(FlowDefinitionRegistry registry) {
        this.addFlowDefinitionLocations();
        this.addFlowDefinitionsFromProperties();
        this.getXmlFlowRegistrar().registerFlowDefinitions(registry);
    }

    private void addFlowDefinitionLocations() {
        if (this.locations != null) {
            for (int i = 0; i < this.locations.length; ++i) {
                String flowId = FlowDefinitionResource.conventionalFlowId(this.locations[i]);
                this.getXmlFlowRegistrar().addResource(new FlowDefinitionResource(flowId, this.locations[i], this.getFlowAttributes(flowId)));
            }
        }
    }

    private void addFlowDefinitionsFromProperties() {
        if (this.flowDefinitions != null) {
            Iterator<Map.Entry<Object, Object>> it = this.flowDefinitions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String flowId = (String)entry.getKey();
                String location = (String)entry.getValue();
                Resource resource = this.getFlowServiceLocator().getResourceLoader().getResource(location);
                this.getXmlFlowRegistrar().addResource(new FlowDefinitionResource(flowId, resource, this.getFlowAttributes(flowId)));
            }
        }
    }

    private AttributeMap getFlowAttributes(String flowId) {
        Map attributes;
        if (this.flowAttributes != null && (attributes = (Map)this.flowAttributes.get(flowId)) != null) {
            return new LocalAttributeMap(attributes);
        }
        return null;
    }
}

