/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.portlet;

import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.springframework.core.style.ToStringCreator;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.portlet.PortletContextMap;
import org.springframework.webflow.context.portlet.PortletRequestMap;
import org.springframework.webflow.context.portlet.PortletRequestParameterMap;
import org.springframework.webflow.context.portlet.PortletSessionMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.LocalParameterMap;
import org.springframework.webflow.core.collection.LocalSharedAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.core.collection.SharedAttributeMap;

public class PortletExternalContext
implements ExternalContext {
    private PortletContext context;
    private PortletRequest request;
    private PortletResponse response;
    private ParameterMap requestParameterMap;
    private MutableAttributeMap requestMap;
    private SharedAttributeMap sessionMap;
    private SharedAttributeMap globalSessionMap;
    private SharedAttributeMap applicationMap;
    private MutableAttributeMap userInfoMap;

    public PortletExternalContext(PortletContext context, PortletRequest request, PortletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
        this.requestParameterMap = new LocalParameterMap((Map)((Object)new PortletRequestParameterMap(request)));
        this.requestMap = new LocalAttributeMap((Map)((Object)new PortletRequestMap(request)));
        this.sessionMap = new LocalSharedAttributeMap(new PortletSessionMap(request, 2));
        this.globalSessionMap = new LocalSharedAttributeMap(new PortletSessionMap(request, 1));
        this.applicationMap = new LocalSharedAttributeMap(new PortletContextMap(context));
        Map userInfo = (Map)request.getAttribute("javax.portlet.userinfo");
        this.userInfoMap = userInfo != null ? new LocalAttributeMap(userInfo) : null;
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getDispatcherPath() {
        return null;
    }

    public String getRequestPathInfo() {
        return null;
    }

    public ParameterMap getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public MutableAttributeMap getRequestMap() {
        return this.requestMap;
    }

    public SharedAttributeMap getSessionMap() {
        return this.sessionMap;
    }

    public SharedAttributeMap getGlobalSessionMap() {
        return this.globalSessionMap;
    }

    public SharedAttributeMap getApplicationMap() {
        return this.applicationMap;
    }

    public MutableAttributeMap getUserInfoMap() {
        return this.userInfoMap;
    }

    public PortletContext getContext() {
        return this.context;
    }

    public PortletRequest getRequest() {
        return this.request;
    }

    public PortletResponse getResponse() {
        return this.response;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("requestParameterMap", (Object)this.getRequestParameterMap()).toString();
    }
}

