/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.definition.registry;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionConstructionException;
import org.springframework.webflow.definition.registry.FlowDefinitionHolder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.definition.registry.NoSuchFlowDefinitionException;

public class FlowDefinitionRegistryImpl
implements FlowDefinitionRegistry {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$definition$registry$FlowDefinitionRegistryImpl == null ? (class$org$springframework$webflow$definition$registry$FlowDefinitionRegistryImpl = FlowDefinitionRegistryImpl.class$("org.springframework.webflow.definition.registry.FlowDefinitionRegistryImpl")) : class$org$springframework$webflow$definition$registry$FlowDefinitionRegistryImpl));
    private Map flowDefinitions = new TreeMap();
    private FlowDefinitionRegistry parent;
    static /* synthetic */ Class class$org$springframework$webflow$definition$registry$FlowDefinitionRegistryImpl;

    public String[] getFlowDefinitionIds() {
        return this.flowDefinitions.keySet().toArray(new String[this.flowDefinitions.size()]);
    }

    public int getFlowDefinitionCount() {
        return this.flowDefinitions.size();
    }

    public boolean containsFlowDefinition(String id) {
        Assert.hasText((String)id, (String)"The flow id is required");
        return this.flowDefinitions.get(id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws FlowDefinitionConstructionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Refreshing flow definition registry '" + this + "'"));
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            LinkedList<Indexed> needsReindexing = new LinkedList<Indexed>();
            Iterator it = this.flowDefinitions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                FlowDefinitionHolder holder = (FlowDefinitionHolder)entry.getValue();
                holder.refresh();
                if (holder.getFlowDefinitionId().equals(key)) continue;
                needsReindexing.add(new Indexed(key, holder));
            }
            it = needsReindexing.iterator();
            while (it.hasNext()) {
                Indexed indexed = (Indexed)((Object)it.next());
                this.reindex(indexed.holder, indexed.key);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String flowId) throws NoSuchFlowDefinitionException, FlowDefinitionConstructionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Refreshing flow with id '" + flowId + "'"));
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            FlowDefinitionHolder holder = this.getFlowDefinitionHolder(flowId);
            holder.refresh();
            if (!holder.getFlowDefinitionId().equals(flowId)) {
                this.reindex(holder, flowId);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    public FlowDefinition getFlowDefinition(String id) throws NoSuchFlowDefinitionException, FlowDefinitionConstructionException {
        Assert.hasText((String)id, (String)"Unable to load a flow definition: no flow id was provided.  Please provide a valid flow identifier.");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting flow definition with id '" + id + "'"));
        }
        try {
            return this.getFlowDefinitionHolder(id).getFlowDefinition();
        }
        catch (NoSuchFlowDefinitionException e) {
            if (this.parent != null) {
                return this.parent.getFlowDefinition(id);
            }
            throw e;
        }
    }

    public void setParent(FlowDefinitionRegistry parent) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting parent flow definition registry to '" + parent + "'"));
        }
        this.parent = parent;
    }

    public FlowDefinition[] getFlowDefinitions() throws FlowDefinitionConstructionException {
        FlowDefinition[] flows = new FlowDefinition[this.flowDefinitions.size()];
        Iterator it = this.flowDefinitions.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            FlowDefinitionHolder holder = (FlowDefinitionHolder)it.next();
            flows[i] = holder.getFlowDefinition();
            ++i;
        }
        return flows;
    }

    public void registerFlowDefinition(FlowDefinitionHolder flowHolder) {
        Assert.notNull((Object)flowHolder, (String)"The flow definition holder to register is required");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering flow definition with id '" + flowHolder.getFlowDefinitionId() + "'"));
        }
        this.index(flowHolder);
    }

    public void removeFlowDefinition(String id) {
        Assert.hasText((String)id, (String)"The flow id is required");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing flow definition with id '" + id + "'"));
        }
        this.flowDefinitions.remove(id);
    }

    private void reindex(FlowDefinitionHolder holder, String oldId) {
        this.flowDefinitions.remove(oldId);
        this.index(holder);
    }

    private void index(FlowDefinitionHolder holder) {
        Assert.hasText((String)holder.getFlowDefinitionId(), (String)"The flow holder to index must return a non-blank flow id");
        this.flowDefinitions.put(holder.getFlowDefinitionId(), holder);
    }

    private FlowDefinitionHolder getFlowDefinitionHolder(String id) throws NoSuchFlowDefinitionException {
        FlowDefinitionHolder flowHolder = (FlowDefinitionHolder)this.flowDefinitions.get(id);
        if (flowHolder == null) {
            throw new NoSuchFlowDefinitionException(id, this.getFlowDefinitionIds());
        }
        return flowHolder;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flowDefinitions", (Object)this.flowDefinitions).append("parent", (Object)this.parent).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Indexed {
        private String key;
        private FlowDefinitionHolder holder;

        public Indexed(String key, FlowDefinitionHolder holder) {
            this.key = key;
            this.holder = holder;
        }
    }
}

