/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.Converter;
import org.springframework.binding.convert.support.CompositeConversionService;
import org.springframework.binding.convert.support.DefaultConversionService;
import org.springframework.binding.convert.support.GenericConversionService;
import org.springframework.binding.convert.support.TextToExpression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.method.TextToMethodSignature;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.webflow.action.BeanInvokingActionFactory;
import org.springframework.webflow.core.DefaultExpressionParserFactory;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowAttributeMapper;
import org.springframework.webflow.engine.FlowExecutionExceptionHandler;
import org.springframework.webflow.engine.TargetStateResolver;
import org.springframework.webflow.engine.TransitionCriteria;
import org.springframework.webflow.engine.ViewSelector;
import org.springframework.webflow.engine.builder.FlowArtifactFactory;
import org.springframework.webflow.engine.builder.FlowArtifactLookupException;
import org.springframework.webflow.engine.builder.FlowServiceLocator;
import org.springframework.webflow.engine.builder.TextToTargetStateResolver;
import org.springframework.webflow.engine.builder.TextToTransitionCriteria;
import org.springframework.webflow.engine.builder.TextToViewSelector;
import org.springframework.webflow.execution.Action;

public class BaseFlowServiceLocator
implements FlowServiceLocator {
    private FlowArtifactFactory flowArtifactFactory = new FlowArtifactFactory();
    private BeanInvokingActionFactory beanInvokingActionFactory = new BeanInvokingActionFactory();
    private ExpressionParser expressionParser = DefaultExpressionParserFactory.getExpressionParser();
    private ConversionService conversionService = this.createConversionService(null);
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    static /* synthetic */ Class class$org$springframework$webflow$engine$Flow;
    static /* synthetic */ Class class$org$springframework$webflow$execution$Action;
    static /* synthetic */ Class class$org$springframework$webflow$engine$FlowAttributeMapper;
    static /* synthetic */ Class class$org$springframework$webflow$engine$TransitionCriteria;
    static /* synthetic */ Class class$org$springframework$webflow$engine$TargetStateResolver;
    static /* synthetic */ Class class$org$springframework$webflow$engine$ViewSelector;
    static /* synthetic */ Class class$org$springframework$webflow$engine$FlowExecutionExceptionHandler;

    public void setFlowArtifactFactory(FlowArtifactFactory flowArtifactFactory) {
        Assert.notNull((Object)flowArtifactFactory, (String)"The flow artifact factory is required");
        this.flowArtifactFactory = flowArtifactFactory;
    }

    public void setBeanInvokingActionFactory(BeanInvokingActionFactory beanInvokingActionFactory) {
        Assert.notNull((Object)beanInvokingActionFactory, (String)"The bean invoking action factory is required");
        this.beanInvokingActionFactory = beanInvokingActionFactory;
    }

    public void setExpressionParser(ExpressionParser expressionParser) {
        Assert.notNull((Object)expressionParser, (String)"The expression parser is required");
        this.expressionParser = expressionParser;
    }

    public void setConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"The conversion service is required");
        this.conversionService = this.createConversionService(conversionService);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Flow getSubflow(String id) throws FlowArtifactLookupException {
        throw new FlowArtifactLookupException(id, class$org$springframework$webflow$engine$Flow == null ? (class$org$springframework$webflow$engine$Flow = BaseFlowServiceLocator.class$("org.springframework.webflow.engine.Flow")) : class$org$springframework$webflow$engine$Flow, "Subflow lookup is not supported by this service locator");
    }

    public Action getAction(String id) throws FlowArtifactLookupException {
        return (Action)this.getBean(id, class$org$springframework$webflow$execution$Action == null ? (class$org$springframework$webflow$execution$Action = BaseFlowServiceLocator.class$("org.springframework.webflow.execution.Action")) : class$org$springframework$webflow$execution$Action);
    }

    public FlowAttributeMapper getAttributeMapper(String id) throws FlowArtifactLookupException {
        return (FlowAttributeMapper)this.getBean(id, class$org$springframework$webflow$engine$FlowAttributeMapper == null ? (class$org$springframework$webflow$engine$FlowAttributeMapper = BaseFlowServiceLocator.class$("org.springframework.webflow.engine.FlowAttributeMapper")) : class$org$springframework$webflow$engine$FlowAttributeMapper);
    }

    public TransitionCriteria getTransitionCriteria(String id) throws FlowArtifactLookupException {
        return (TransitionCriteria)this.getBean(id, class$org$springframework$webflow$engine$TransitionCriteria == null ? (class$org$springframework$webflow$engine$TransitionCriteria = BaseFlowServiceLocator.class$("org.springframework.webflow.engine.TransitionCriteria")) : class$org$springframework$webflow$engine$TransitionCriteria);
    }

    public TargetStateResolver getTargetStateResolver(String id) throws FlowArtifactLookupException {
        return (TargetStateResolver)this.getBean(id, class$org$springframework$webflow$engine$TargetStateResolver == null ? (class$org$springframework$webflow$engine$TargetStateResolver = BaseFlowServiceLocator.class$("org.springframework.webflow.engine.TargetStateResolver")) : class$org$springframework$webflow$engine$TargetStateResolver);
    }

    public ViewSelector getViewSelector(String id) throws FlowArtifactLookupException {
        return (ViewSelector)this.getBean(id, class$org$springframework$webflow$engine$ViewSelector == null ? (class$org$springframework$webflow$engine$ViewSelector = BaseFlowServiceLocator.class$("org.springframework.webflow.engine.ViewSelector")) : class$org$springframework$webflow$engine$ViewSelector);
    }

    public FlowExecutionExceptionHandler getExceptionHandler(String id) throws FlowArtifactLookupException {
        return (FlowExecutionExceptionHandler)this.getBean(id, class$org$springframework$webflow$engine$FlowExecutionExceptionHandler == null ? (class$org$springframework$webflow$engine$FlowExecutionExceptionHandler = BaseFlowServiceLocator.class$("org.springframework.webflow.engine.FlowExecutionExceptionHandler")) : class$org$springframework$webflow$engine$FlowExecutionExceptionHandler);
    }

    public FlowArtifactFactory getFlowArtifactFactory() {
        return this.flowArtifactFactory;
    }

    public BeanInvokingActionFactory getBeanInvokingActionFactory() {
        return this.beanInvokingActionFactory;
    }

    public BeanFactory getBeanFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Bean factory lookup is not supported by this service locator");
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    protected boolean containsBean(String id) {
        return this.getBeanFactory().containsBean(id);
    }

    protected Object getBean(String id, Class artifactType) throws FlowArtifactLookupException {
        try {
            return this.getBeanFactory().getBean(id, artifactType);
        }
        catch (BeansException e) {
            throw new FlowArtifactLookupException(id, artifactType, e);
        }
    }

    protected Class getBeanType(String id, Class artifactType) throws FlowArtifactLookupException {
        try {
            return this.getBeanFactory().getType(id);
        }
        catch (BeansException e) {
            throw new FlowArtifactLookupException(id, artifactType, e);
        }
    }

    protected ConversionService createConversionService(ConversionService userConversionService) {
        DefaultConversionService defaultConversionService = new DefaultConversionService();
        this.addWebFlowConverters((GenericConversionService)defaultConversionService);
        if (userConversionService != null) {
            return new CompositeConversionService(new ConversionService[]{userConversionService, defaultConversionService});
        }
        return defaultConversionService;
    }

    protected void addWebFlowConverters(GenericConversionService conversionService) {
        conversionService.addConverter((Converter)new TextToTransitionCriteria(this));
        conversionService.addConverter((Converter)new TextToTargetStateResolver(this));
        conversionService.addConverter((Converter)new TextToViewSelector(this));
        conversionService.addConverter((Converter)new TextToExpression(this.getExpressionParser()));
        conversionService.addConverter((Converter)new TextToMethodSignature((ConversionService)conversionService));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

