/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.impl.FlowExecutionListeners;
import org.springframework.webflow.engine.impl.FlowSessionImpl;
import org.springframework.webflow.engine.impl.RequestControlContextImpl;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.FlowSessionStatus;
import org.springframework.webflow.execution.ViewSelection;

public class FlowExecutionImpl
implements FlowExecution,
Externalizable {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$webflow$engine$impl$FlowExecutionImpl == null ? (class$org$springframework$webflow$engine$impl$FlowExecutionImpl = FlowExecutionImpl.class$("org.springframework.webflow.engine.impl.FlowExecutionImpl")) : class$org$springframework$webflow$engine$impl$FlowExecutionImpl));
    private transient Flow flow;
    private LinkedList flowSessions;
    private transient FlowExecutionListeners listeners;
    private transient MutableAttributeMap conversationScope;
    private transient AttributeMap attributes;
    private String flowId;
    static /* synthetic */ Class class$org$springframework$webflow$engine$impl$FlowExecutionImpl;

    public FlowExecutionImpl() {
    }

    public FlowExecutionImpl(Flow flow) {
        this(flow, new FlowExecutionListener[0], null);
    }

    public FlowExecutionImpl(Flow flow, FlowExecutionListener[] listeners, AttributeMap attributes) {
        this.setFlow(flow);
        this.flowSessions = new LinkedList();
        this.listeners = new FlowExecutionListeners(listeners);
        this.attributes = attributes != null ? attributes : CollectionUtils.EMPTY_ATTRIBUTE_MAP;
        this.conversationScope = new LocalAttributeMap();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created new execution of flow '" + flow.getId() + "'"));
        }
    }

    public String getCaption() {
        return "execution of '" + this.flowId + "'";
    }

    public FlowDefinition getDefinition() {
        return this.flow;
    }

    public boolean isActive() {
        return !this.flowSessions.isEmpty();
    }

    public FlowSession getActiveSession() {
        return this.getActiveSessionInternal();
    }

    public MutableAttributeMap getConversationScope() {
        return this.conversationScope;
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewSelection start(MutableAttributeMap input, ExternalContext externalContext) throws FlowExecutionException {
        Assert.state((!this.isActive() ? 1 : 0) != 0, (String)"This flow is already executing -- you cannot call 'start()' more than once");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting execution with input '" + input + "'"));
        }
        RequestControlContext context = this.createControlContext(externalContext);
        this.getListeners().fireRequestSubmitted(context);
        try {
            ViewSelection selectedView = context.start(this.flow, input);
            ViewSelection viewSelection = this.pause(context, selectedView);
            return viewSelection;
        }
        catch (FlowExecutionException e) {
            ViewSelection viewSelection = this.pause(context, this.handleException(e, context));
            return viewSelection;
        }
        finally {
            this.getListeners().fireRequestProcessed(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewSelection signalEvent(String eventId, ExternalContext externalContext) throws FlowExecutionException {
        this.assertActive();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resuming execution on user event '" + eventId + "'"));
        }
        RequestControlContext context = this.createControlContext(externalContext);
        context.getFlashScope().clear();
        this.getListeners().fireRequestSubmitted(context);
        try {
            this.resume(context);
            Event event = new Event(externalContext, eventId, externalContext.getRequestParameterMap().asAttributeMap());
            ViewSelection selectedView = context.signalEvent(event);
            ViewSelection viewSelection = this.pause(context, selectedView);
            return viewSelection;
        }
        catch (FlowExecutionException e) {
            ViewSelection viewSelection = this.pause(context, this.handleException(e, context));
            return viewSelection;
        }
        finally {
            this.getListeners().fireRequestProcessed(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewSelection refresh(ExternalContext externalContext) throws FlowExecutionException {
        this.assertActive();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Resuming execution for refresh");
        }
        RequestControlContext context = this.createControlContext(externalContext);
        this.getListeners().fireRequestSubmitted(context);
        try {
            this.resume(context);
            State currentState = this.getCurrentState();
            if (!(currentState instanceof ViewState)) {
                throw new IllegalStateException("Current state is not a view state - cannot refresh; perhaps an unhandled exception occured in another state?");
            }
            ViewSelection selectedView = ((ViewState)currentState).refresh(context);
            ViewSelection viewSelection = this.pause(context, selectedView);
            return viewSelection;
        }
        catch (FlowExecutionException e) {
            ViewSelection viewSelection = this.pause(context, this.handleException(e, context));
            return viewSelection;
        }
        finally {
            this.getListeners().fireRequestProcessed(context);
        }
    }

    FlowExecutionListeners getListeners() {
        return this.listeners;
    }

    protected void resume(RequestControlContext context) {
        this.getActiveSessionInternal().setStatus(FlowSessionStatus.ACTIVE);
        this.getListeners().fireResumed(context);
    }

    protected ViewSelection pause(RequestControlContext context, ViewSelection selectedView) {
        if (!this.isActive()) {
            return selectedView;
        }
        this.getActiveSessionInternal().setStatus(FlowSessionStatus.PAUSED);
        this.getListeners().firePaused(context, selectedView);
        if (logger.isDebugEnabled()) {
            if (selectedView != null) {
                logger.debug((Object)("Paused to render " + selectedView + " and wait for user input"));
            } else {
                logger.debug((Object)"Paused to wait for user input");
            }
        }
        return selectedView;
    }

    protected ViewSelection handleException(FlowExecutionException exception, RequestControlContext context) throws FlowExecutionException {
        this.getListeners().fireExceptionThrown(context, exception);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempting to handle [" + (Object)((Object)exception) + "]"));
        }
        try {
            ViewSelection selectedView = this.tryStateHandlers(exception, context);
            if (selectedView != null) {
                return selectedView;
            }
            selectedView = this.tryFlowHandlers(exception, context);
            if (selectedView != null) {
                return selectedView;
            }
        }
        catch (FlowExecutionException newException) {
            return this.handleException(newException, context);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Rethrowing unhandled flow execution exception");
        }
        throw exception;
    }

    private ViewSelection tryStateHandlers(FlowExecutionException exception, RequestControlContext context) {
        ViewSelection selectedView = null;
        if (exception.getStateId() != null && (selectedView = this.getActiveFlow().getStateInstance(exception.getStateId()).handleException(exception, context)) != null && logger.isDebugEnabled()) {
            logger.debug((Object)("State '" + exception.getStateId() + "' handled exception"));
        }
        return selectedView;
    }

    private ViewSelection tryFlowHandlers(FlowExecutionException exception, RequestControlContext context) {
        ViewSelection selectedView = this.getActiveFlow().handleException(exception, context);
        if (selectedView != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Flow '" + exception.getFlowId() + "' handled exception"));
        }
        return selectedView;
    }

    protected RequestControlContext createControlContext(ExternalContext externalContext) {
        return new RequestControlContextImpl(this, externalContext);
    }

    FlowSessionImpl getActiveSessionInternal() throws IllegalStateException {
        this.assertActive();
        return (FlowSessionImpl)this.flowSessions.getLast();
    }

    protected void setCurrentState(State newState) {
        this.getActiveSessionInternal().setState(newState);
    }

    protected FlowSession activateSession(Flow flow) {
        FlowSessionImpl session;
        if (!this.flowSessions.isEmpty()) {
            FlowSessionImpl parent = this.getActiveSessionInternal();
            parent.setStatus(FlowSessionStatus.SUSPENDED);
            session = this.createFlowSession(flow, parent);
        } else {
            session = this.createFlowSession(flow, null);
        }
        this.flowSessions.add(session);
        session.setStatus(FlowSessionStatus.STARTING);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting " + session));
        }
        return session;
    }

    FlowSessionImpl createFlowSession(Flow flow, FlowSessionImpl parent) {
        return new FlowSessionImpl(flow, parent);
    }

    public FlowSession endActiveFlowSession() {
        FlowSessionImpl endingSession = (FlowSessionImpl)this.flowSessions.removeLast();
        endingSession.setStatus(FlowSessionStatus.ENDED);
        if (!this.flowSessions.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resuming session '" + this.getActiveSessionInternal().getDefinition().getId() + "' in state '" + this.getActiveSessionInternal().getState().getId() + "'"));
            }
            this.getActiveSessionInternal().setStatus(FlowSessionStatus.ACTIVE);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"[Ended] - this execution is now inactive");
        }
        return endingSession;
    }

    private void assertActive() throws IllegalStateException {
        if (!this.isActive()) {
            throw new IllegalStateException("This flow execution is not active, it has either ended or has never been started.");
        }
    }

    private Flow getActiveFlow() {
        return (Flow)this.getActiveSessionInternal().getDefinition();
    }

    private State getCurrentState() {
        return (State)this.getActiveSessionInternal().getState();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.flowId = (String)in.readObject();
        this.flowSessions = (LinkedList)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.flowId);
        out.writeObject(this.flowSessions);
    }

    public String toString() {
        if (!this.isActive()) {
            return "[Inactive " + this.getCaption() + "]";
        }
        if (this.flow != null) {
            return new ToStringCreator((Object)this).append("flow", (Object)this.flow.getId()).append("flowSessions", (Object)this.flowSessions).toString();
        }
        return "[Unhydrated " + this.getCaption() + "]";
    }

    void setFlow(Flow flow) {
        Assert.notNull((Object)flow, (String)"The root flow definition is required");
        this.flow = flow;
        this.flowId = flow.getId();
    }

    void setListeners(FlowExecutionListeners listeners) {
        Assert.notNull((Object)listeners, (String)"The execution listener list is required");
        this.listeners = listeners;
    }

    void setAttributes(AttributeMap attributes) {
        Assert.notNull((Object)this.conversationScope, (String)"The execution attribute map is required");
        this.attributes = attributes;
    }

    void setConversationScope(MutableAttributeMap conversationScope) {
        Assert.notNull((Object)conversationScope, (String)"The conversation scope map is required");
        this.conversationScope = conversationScope;
    }

    String getFlowId() {
        return this.flowId;
    }

    LinkedList getFlowSessions() {
        return this.flowSessions;
    }

    boolean hasSessions() {
        return !this.flowSessions.isEmpty();
    }

    boolean hasSubflowSessions() {
        return this.flowSessions.size() > 1;
    }

    FlowSessionImpl getRootSession() {
        return (FlowSessionImpl)this.flowSessions.getFirst();
    }

    ListIterator getSubflowSessionIterator() {
        return this.flowSessions.listIterator(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

