/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class ExecutorBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String CONVERSATION_MANAGER_REF_ATTRIBUTE = "conversation-manager-ref";
    private static final String EXECUTION_ATTRIBUTES_ELEMENT = "execution-attributes";
    private static final String EXECUTION_LISTENERS_ELEMENT = "execution-listeners";
    private static final String MAX_CONTINUATIONS_ATTRIBUTE = "max-continuations";
    private static final String MAX_CONVERSATIONS_ATTRIBUTE = "max-conversations";
    private static final String REGISTRY_REF_ATTRIBUTE = "registry-ref";
    private static final String REPOSITORY_ELEMENT = "repository";
    private static final String REPOSITORY_TYPE_ATTRIBUTE = "repository-type";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String CONVERSATION_MANAGER_PROPERTY = "conversationManager";
    private static final String DEFINITION_LOCATOR_PROPERTY = "definitionLocator";
    private static final String EXECUTION_ATTRIBUTES_PROPERTY = "executionAttributes";
    private static final String EXECUTION_LISTENER_LOADER_PROPERTY = "executionListenerLoader";
    private static final String MAX_CONTINUATIONS_PROPERTY = "maxContinuations";
    private static final String MAX_CONVERSATIONS_PROPERTY = "maxConversations";
    private static final String REPOSITORY_TYPE_PROPERTY = "repositoryType";
    static /* synthetic */ Class class$org$springframework$webflow$config$FlowExecutorFactoryBean;

    ExecutorBeanDefinitionParser() {
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder definitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$webflow$config$FlowExecutorFactoryBean == null ? (class$org$springframework$webflow$config$FlowExecutorFactoryBean = ExecutorBeanDefinitionParser.class$("org.springframework.webflow.config.FlowExecutorFactoryBean")) : class$org$springframework$webflow$config$FlowExecutorFactoryBean));
        definitionBuilder.setSource(parserContext.extractSource((Object)element));
        definitionBuilder.addPropertyReference(DEFINITION_LOCATOR_PROPERTY, this.getRegistryRef(element, parserContext));
        this.addExecutionAttributes(element, parserContext, definitionBuilder);
        this.addExecutionListenerLoader(element, parserContext, definitionBuilder);
        this.configureRepository(element, definitionBuilder, parserContext);
        return definitionBuilder.getBeanDefinition();
    }

    private void configureRepository(Element element, BeanDefinitionBuilder definitionBuilder, ParserContext parserContext) {
        Element repositoryElement = DomUtils.getChildElementByTagName((Element)element, (String)REPOSITORY_ELEMENT);
        String repositoryTypeAttribute = this.getRepositoryType(element);
        if (repositoryElement != null) {
            if (StringUtils.hasText((String)repositoryTypeAttribute)) {
                parserContext.getReaderContext().error("The 'repositoryType' attribute of the 'executor' element must not have a value if there is a 'repository' element", (Object)element);
            }
            definitionBuilder.addPropertyValue(REPOSITORY_TYPE_PROPERTY, (Object)this.getType(repositoryElement));
            this.configureContinuations(repositoryElement, definitionBuilder, parserContext);
            this.configureConversationManager(repositoryElement, definitionBuilder, parserContext);
        } else if (StringUtils.hasText((String)repositoryTypeAttribute)) {
            definitionBuilder.addPropertyValue(REPOSITORY_TYPE_PROPERTY, (Object)repositoryTypeAttribute);
        }
    }

    private void configureContinuations(Element repositoryElement, BeanDefinitionBuilder definitionBuilder, ParserContext parserContext) {
        String maxContinuations = this.getMaxContinuations(repositoryElement);
        if (StringUtils.hasText((String)maxContinuations)) {
            if (!this.getType(repositoryElement).equals("CONTINUATION")) {
                parserContext.getReaderContext().error("The 'max-continuations' attribute of the 'repository' element must not have a value if the 'type' attribute is not 'continuation'", (Object)repositoryElement);
            }
            definitionBuilder.addPropertyValue(MAX_CONTINUATIONS_PROPERTY, (Object)maxContinuations);
        }
    }

    private void configureConversationManager(Element repositoryElement, BeanDefinitionBuilder definitionBuilder, ParserContext parserContext) {
        String conversationManagerRef = this.getConversationManagerRef(repositoryElement);
        String maxConversations = this.getMaxConversations(repositoryElement);
        if (StringUtils.hasText((String)conversationManagerRef)) {
            if (StringUtils.hasText((String)maxConversations)) {
                parserContext.getReaderContext().error("The 'max-conversations' attribute of the 'repository' element must not have a value if there is a value for the 'conversation-manager-ref' attribute", (Object)repositoryElement);
            }
            definitionBuilder.addPropertyReference(CONVERSATION_MANAGER_PROPERTY, conversationManagerRef);
        } else if (StringUtils.hasText((String)maxConversations)) {
            definitionBuilder.addPropertyValue(MAX_CONVERSATIONS_PROPERTY, (Object)maxConversations);
        }
    }

    private String getRegistryRef(Element element, ParserContext parserContext) {
        String registryRef = element.getAttribute(REGISTRY_REF_ATTRIBUTE);
        if (!StringUtils.hasText((String)registryRef)) {
            parserContext.getReaderContext().error("The 'registry-ref' attribute of the 'executor' element must have a value", (Object)element);
        }
        return registryRef;
    }

    private String getRepositoryType(Element element) {
        return element.getAttribute(REPOSITORY_TYPE_ATTRIBUTE).toUpperCase();
    }

    private String getType(Element element) {
        return element.getAttribute(TYPE_ATTRIBUTE).toUpperCase();
    }

    private String getMaxContinuations(Element element) {
        return element.getAttribute(MAX_CONTINUATIONS_ATTRIBUTE);
    }

    private String getMaxConversations(Element element) {
        return element.getAttribute(MAX_CONVERSATIONS_ATTRIBUTE);
    }

    private String getConversationManagerRef(Element element) {
        return element.getAttribute(CONVERSATION_MANAGER_REF_ATTRIBUTE);
    }

    private void addExecutionAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder definitionBuilder) {
        Element attributesElement = DomUtils.getChildElementByTagName((Element)element, (String)EXECUTION_ATTRIBUTES_ELEMENT);
        if (attributesElement != null) {
            definitionBuilder.addPropertyValue(EXECUTION_ATTRIBUTES_PROPERTY, (Object)parserContext.getDelegate().parseCustomElement(attributesElement, (BeanDefinition)definitionBuilder.getBeanDefinition()));
        }
    }

    private void addExecutionListenerLoader(Element element, ParserContext parserContext, BeanDefinitionBuilder definitionBuilder) {
        Element listenersElement = DomUtils.getChildElementByTagName((Element)element, (String)EXECUTION_LISTENERS_ELEMENT);
        if (listenersElement != null) {
            definitionBuilder.addPropertyValue(EXECUTION_LISTENER_LOADER_PROPERTY, (Object)parserContext.getDelegate().parseCustomElement(listenersElement, (BeanDefinition)definitionBuilder.getBeanDefinition()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

