/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.servlet;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.binding.collection.SharedMap;
import org.springframework.binding.collection.StringKeyedMapAdapter;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.context.servlet.HttpSessionMapBindingListener;
import org.springframework.webflow.core.collection.AttributeMapBindingListener;
import org.springframework.webflow.core.collection.CollectionUtils;

public class HttpSessionMap
extends StringKeyedMapAdapter
implements SharedMap {
    private HttpServletRequest request;

    public HttpSessionMap(HttpServletRequest request) {
        this.request = request;
    }

    private HttpSession getSession() {
        return this.request.getSession(false);
    }

    protected Object getAttribute(String key) {
        HttpSession session = this.getSession();
        if (session == null) {
            return null;
        }
        Object value = session.getAttribute(key);
        if (value instanceof HttpSessionMapBindingListener) {
            return ((HttpSessionMapBindingListener)value).getListener();
        }
        return value;
    }

    protected void setAttribute(String key, Object value) {
        HttpSession session = this.request.getSession(true);
        if (value instanceof AttributeMapBindingListener) {
            session.setAttribute(key, (Object)new HttpSessionMapBindingListener((AttributeMapBindingListener)value, (Map)((Object)this)));
        } else {
            session.setAttribute(key, value);
        }
    }

    protected void removeAttribute(String key) {
        HttpSession session = this.getSession();
        if (session != null) {
            session.removeAttribute(key);
        }
    }

    protected Iterator getAttributeNames() {
        HttpSession session = this.getSession();
        return session == null ? CollectionUtils.EMPTY_ITERATOR : CollectionUtils.toIterator(session.getAttributeNames());
    }

    public Object getMutex() {
        HttpSession session = this.request.getSession(true);
        Object mutex = session.getAttribute(WebUtils.SESSION_MUTEX_ATTRIBUTE);
        return mutex != null ? mutex : session;
    }
}

