/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.jsf;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.ViewSelection;
import org.springframework.webflow.execution.repository.FlowExecutionAccessException;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.support.ApplicationView;
import org.springframework.webflow.execution.support.ExternalRedirect;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;
import org.springframework.webflow.execution.support.FlowExecutionRedirect;
import org.springframework.webflow.executor.RequestParameterInputMapper;
import org.springframework.webflow.executor.ResponseInstruction;
import org.springframework.webflow.executor.jsf.FlowExecutionHolder;
import org.springframework.webflow.executor.jsf.FlowExecutionHolderUtils;
import org.springframework.webflow.executor.jsf.FlowExecutionKeyStateHolder;
import org.springframework.webflow.executor.jsf.FlowFacesUtils;
import org.springframework.webflow.executor.jsf.JsfExternalContext;
import org.springframework.webflow.executor.jsf.ViewIdMapper;
import org.springframework.webflow.executor.support.FlowExecutorArgumentHandler;
import org.springframework.webflow.executor.support.RequestParameterFlowExecutorArgumentHandler;
import org.springframework.webflow.executor.support.ResponseInstructionHandler;

public class FlowPhaseListener
implements PhaseListener {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private FlowExecutorArgumentHandler argumentHandler = new RequestParameterFlowExecutorArgumentHandler();
    private AttributeMapper inputMapper = new RequestParameterInputMapper();
    private ViewIdMapper viewIdMapper = new DefaultViewIdMapper();

    public FlowExecutorArgumentHandler getArgumentHandler() {
        return this.argumentHandler;
    }

    public void setArgumentHandler(FlowExecutorArgumentHandler argumentHandler) {
        this.argumentHandler = argumentHandler;
    }

    public AttributeMapper getInputMapper() {
        return this.inputMapper;
    }

    public void setInputMapper(AttributeMapper inputMapper) {
        this.inputMapper = inputMapper;
    }

    public ViewIdMapper getViewIdMapper() {
        return this.viewIdMapper;
    }

    public void setViewIdMapper(ViewIdMapper viewIdMapper) {
        this.viewIdMapper = viewIdMapper;
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            ExternalContextHolder.setExternalContext(new JsfExternalContext(context));
            this.restoreFlowExecution(event.getFacesContext());
        } else if (event.getPhaseId() == PhaseId.RENDER_RESPONSE && FlowExecutionHolderUtils.isFlowExecutionRestored(event.getFacesContext())) {
            try {
                this.prepareResponse(this.getCurrentContext(), FlowExecutionHolderUtils.getFlowExecutionHolder(context));
            }
            catch (RuntimeException e) {
                this.cleanupResources(context);
                throw e;
            }
            catch (Error e) {
                this.cleanupResources(context);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            if (FlowExecutionHolderUtils.isFlowExecutionRestored(context)) {
                try {
                    this.saveFlowExecution(this.getCurrentContext(), FlowExecutionHolderUtils.getFlowExecutionHolder(context));
                }
                finally {
                    this.cleanupResources(context);
                }
            }
        } else if (context.getResponseComplete()) {
            this.cleanupResources(context);
        }
    }

    protected void restoreFlowExecution(FacesContext facesContext) {
        JsfExternalContext context = new JsfExternalContext(facesContext);
        if (this.argumentHandler.isFlowExecutionKeyPresent(context)) {
            FlowExecutionRepository repository = this.getRepository(context);
            FlowExecutionKey flowExecutionKey = repository.parseFlowExecutionKey(this.argumentHandler.extractFlowExecutionKey(context));
            try {
                FlowExecutionLock lock = repository.getLock(flowExecutionKey);
                lock.lock();
                try {
                    FlowExecution flowExecution = repository.getFlowExecution(flowExecutionKey);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Loaded existing flow execution with key '" + flowExecutionKey + "' due to browser access " + "[either via a flow execution redirect or direct browser refresh]"));
                    }
                    FlowExecutionHolderUtils.setFlowExecutionHolder(new FlowExecutionHolder(flowExecutionKey, flowExecution, lock), facesContext);
                }
                catch (RuntimeException e) {
                    lock.unlock();
                    throw e;
                }
                catch (Error e) {
                    lock.unlock();
                    throw e;
                }
            }
            catch (FlowExecutionAccessException e) {
                this.handleFlowExecutionAccessException(e, facesContext);
            }
        } else if (this.argumentHandler.isFlowIdPresent(context)) {
            String flowId = this.argumentHandler.extractFlowId(context);
            FlowDefinition flowDefinition = this.getLocator(context).getFlowDefinition(flowId);
            FlowExecution flowExecution = this.getFactory(context).createFlowExecution(flowDefinition);
            FlowExecutionHolder holder = new FlowExecutionHolder(flowExecution);
            FlowExecutionHolderUtils.setFlowExecutionHolder(holder, facesContext);
            ViewSelection selectedView = flowExecution.start(this.createInput(context), context);
            holder.setViewSelection(selectedView);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Launched a new flow execution due to browser access [either via a flow redirect or direct browser URL access]");
            }
        }
    }

    protected void handleFlowExecutionAccessException(FlowExecutionAccessException e, FacesContext context) {
        throw e;
    }

    protected MutableAttributeMap createInput(ExternalContext context) {
        if (this.inputMapper != null) {
            LocalAttributeMap inputMap = new LocalAttributeMap();
            this.inputMapper.map((Object)context, (Object)inputMap, null);
            return inputMap;
        }
        return null;
    }

    protected void prepareResponse(final JsfExternalContext context, final FlowExecutionHolder holder) {
        ViewSelection selectedView = holder.getViewSelection();
        if (selectedView == null) {
            selectedView = holder.getFlowExecution().refresh(context);
            holder.setViewSelection(selectedView);
        } else {
            this.generateKey(context, holder);
        }
        new ResponseInstructionHandler(){

            protected void handleApplicationView(ApplicationView view) throws Exception {
                FlowPhaseListener.this.prepareApplicationView(context.getFacesContext(), holder);
            }

            protected void handleFlowDefinitionRedirect(FlowDefinitionRedirect redirect) throws Exception {
                String url = FlowPhaseListener.this.argumentHandler.createFlowDefinitionUrl(redirect, context);
                FlowPhaseListener.this.sendRedirect(url, context.getFacesContext());
            }

            protected void handleFlowExecutionRedirect(FlowExecutionRedirect redirect) throws Exception {
                String url = FlowPhaseListener.this.argumentHandler.createFlowExecutionUrl(holder.getFlowExecutionKey().toString(), holder.getFlowExecution(), context);
                FlowPhaseListener.this.sendRedirect(url, context.getFacesContext());
            }

            protected void handleExternalRedirect(ExternalRedirect redirect) throws Exception {
                String flowExecutionKey = holder.getFlowExecution().isActive() ? holder.getFlowExecutionKey().toString() : null;
                String url = FlowPhaseListener.this.argumentHandler.createExternalUrl(redirect, flowExecutionKey, context);
                FlowPhaseListener.this.sendRedirect(url, context.getFacesContext());
            }

            protected void handleNull() throws Exception {
            }
        }.handleQuietly(new ResponseInstruction(holder.getFlowExecution(), selectedView));
    }

    protected void prepareApplicationView(FacesContext facesContext, FlowExecutionHolder holder) {
        String flowExecutionKey;
        ApplicationView view = (ApplicationView)holder.getViewSelection();
        if (view != null) {
            this.putInto(facesContext.getExternalContext().getRequestMap(), view.getModel());
            this.updateViewRoot(facesContext, this.viewIdMapper.mapViewId(view.getViewName()));
        }
        String string = flowExecutionKey = holder.getFlowExecution().isActive() ? holder.getFlowExecutionKey().toString() : null;
        if (flowExecutionKey != null) {
            this.saveInViewRoot(facesContext, flowExecutionKey);
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        this.argumentHandler.exposeFlowExecutionContext(flowExecutionKey, holder.getFlowExecution(), requestMap);
    }

    protected FlowExecutionKeyStateHolder createFlowExecutionKeyStateHolder() {
        return new FlowExecutionKeyStateHolder();
    }

    protected void saveFlowExecution(JsfExternalContext context, FlowExecutionHolder holder) {
        FlowExecution flowExecution = holder.getFlowExecution();
        FlowExecutionRepository repository = this.getRepository(context);
        if (flowExecution.isActive()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Saving execution to repository with key " + holder.getFlowExecutionKey()));
            }
            repository.putFlowExecution(holder.getFlowExecutionKey(), flowExecution);
        } else if (holder.getFlowExecutionKey() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Removing execution in repository with key '" + holder.getFlowExecutionKey() + "'"));
            }
            repository.removeFlowExecution(holder.getFlowExecutionKey());
        }
    }

    protected void sendRedirect(String url, FacesContext context) {
        try {
            url = context.getExternalContext().encodeResourceURL(url);
            context.getExternalContext().redirect(url);
            context.responseComplete();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not send redirect to " + url);
        }
    }

    private JsfExternalContext getCurrentContext() {
        return (JsfExternalContext)ExternalContextHolder.getExternalContext();
    }

    private void cleanupResources(FacesContext context) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Cleaning up allocated flow system resources");
        }
        FlowExecutionHolderUtils.cleanupCurrentFlowExecution(context);
        ExternalContextHolder.setExternalContext(null);
    }

    private void updateViewRoot(FacesContext facesContext, String viewId) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot == null || this.hasViewChanged(viewRoot, viewId)) {
            ViewHandler handler = facesContext.getApplication().getViewHandler();
            UIViewRoot view = handler.createView(facesContext, viewId);
            facesContext.setViewRoot(view);
        }
    }

    private boolean hasViewChanged(UIViewRoot viewRoot, String viewId) {
        return !viewRoot.getViewId().equals(viewId);
    }

    private void saveInViewRoot(FacesContext facesContext, String flowExecutionKey) {
        FlowExecutionKeyStateHolder keyHolder = (FlowExecutionKeyStateHolder)facesContext.getViewRoot().findComponent("FlowExecutionKeyStateHolder");
        if (keyHolder == null) {
            keyHolder = this.createFlowExecutionKeyStateHolder();
            facesContext.getViewRoot().getChildren().add(keyHolder);
        }
        keyHolder.setFlowExecutionKey(flowExecutionKey);
    }

    private void generateKey(JsfExternalContext context, FlowExecutionHolder holder) {
        FlowExecution flowExecution = holder.getFlowExecution();
        if (flowExecution.isActive()) {
            FlowExecutionKey flowExecutionKey = holder.getFlowExecutionKey();
            FlowExecutionRepository repository = this.getRepository(context);
            if (flowExecutionKey == null) {
                flowExecutionKey = repository.generateKey(flowExecution);
                FlowExecutionLock lock = repository.getLock(flowExecutionKey);
                lock.lock();
                holder.setFlowExecutionLock(lock);
            } else {
                flowExecutionKey = repository.getNextKey(flowExecution, flowExecutionKey);
            }
            holder.setFlowExecutionKey(flowExecutionKey);
        }
    }

    private void putInto(Map targetMap, Map map) {
        try {
            targetMap.putAll(map);
        }
        catch (UnsupportedOperationException e) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                targetMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private FlowDefinitionLocator getLocator(JsfExternalContext context) {
        return FlowFacesUtils.getDefinitionLocator(context.getFacesContext());
    }

    private FlowExecutionFactory getFactory(JsfExternalContext context) {
        return FlowFacesUtils.getExecutionFactory(context.getFacesContext());
    }

    private FlowExecutionRepository getRepository(JsfExternalContext context) {
        return FlowFacesUtils.getExecutionRepository(context.getFacesContext());
    }

    public static class DefaultViewIdMapper
    implements ViewIdMapper {
        public String mapViewId(String viewName) {
            return viewName;
        }
    }
}

