/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive;

import org.springframework.ui.Model;
import org.springframework.validation.support.BindingAwareConcurrentModel;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.server.ServerWebExchange;

public class BindingContext {
    private final WebBindingInitializer initializer;
    private final Model model = new BindingAwareConcurrentModel();

    public BindingContext() {
        this(null);
    }

    public BindingContext(WebBindingInitializer initializer) {
        this.initializer = initializer;
    }

    public Model getModel() {
        return this.model;
    }

    public WebExchangeDataBinder createDataBinder(ServerWebExchange exchange, Object target, String name) {
        WebExchangeDataBinder dataBinder = new WebExchangeDataBinder(target, name);
        if (this.initializer != null) {
            this.initializer.initBinder((WebDataBinder)dataBinder);
        }
        return this.initDataBinder(dataBinder, exchange);
    }

    protected WebExchangeDataBinder initDataBinder(WebExchangeDataBinder binder, ServerWebExchange exchange) {
        return binder;
    }

    public WebExchangeDataBinder createDataBinder(ServerWebExchange exchange, String name) {
        return this.createDataBinder(exchange, null, name);
    }
}

