/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.UnsupportedMediaTypeException;
import reactor.core.publisher.Mono;

public abstract class BodyInserters {
    private static final ResolvableType RESOURCE_TYPE = ResolvableType.forClass(Resource.class);
    private static final ResolvableType SERVER_SIDE_EVENT_TYPE = ResolvableType.forClass(ServerSentEvent.class);
    private static final ResolvableType FORM_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, String.class});
    private static final ResolvableType MULTIPART_VALUE_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, Part.class});
    private static final BodyInserter<Void, ReactiveHttpOutputMessage> EMPTY = (response, context) -> response.setComplete();

    public static <T> BodyInserter<T, ReactiveHttpOutputMessage> empty() {
        return EMPTY;
    }

    public static <T> BodyInserter<T, ReactiveHttpOutputMessage> fromObject(T body) {
        Assert.notNull(body, (String)"'body' must not be null");
        return BodyInserters.bodyInserterFor(Mono.just(body), ResolvableType.forInstance(body));
    }

    public static <T, P extends Publisher<T>> BodyInserter<P, ReactiveHttpOutputMessage> fromPublisher(P publisher, Class<T> elementClass) {
        Assert.notNull(publisher, (String)"'publisher' must not be null");
        Assert.notNull(elementClass, (String)"'elementClass' must not be null");
        return BodyInserters.bodyInserterFor(publisher, ResolvableType.forClass(elementClass));
    }

    public static <T, P extends Publisher<T>> BodyInserter<P, ReactiveHttpOutputMessage> fromPublisher(P publisher, ResolvableType elementType) {
        Assert.notNull(publisher, (String)"'publisher' must not be null");
        Assert.notNull((Object)elementType, (String)"'elementType' must not be null");
        return BodyInserters.bodyInserterFor(publisher, elementType);
    }

    public static <T extends Resource> BodyInserter<T, ReactiveHttpOutputMessage> fromResource(T resource) {
        Assert.notNull(resource, (String)"'resource' must not be null");
        return (outputMessage, context) -> {
            Mono inputStream = Mono.just((Object)resource);
            HttpMessageWriter<Resource> messageWriter = BodyInserters.resourceHttpMessageWriter(context);
            Optional<ServerHttpRequest> serverRequest = context.serverRequest();
            if (serverRequest.isPresent() && outputMessage instanceof ServerHttpResponse) {
                return messageWriter.write((Publisher)inputStream, RESOURCE_TYPE, RESOURCE_TYPE, null, serverRequest.get(), (ServerHttpResponse)outputMessage, context.hints());
            }
            return messageWriter.write((Publisher)inputStream, RESOURCE_TYPE, null, outputMessage, context.hints());
        };
    }

    private static HttpMessageWriter<Resource> resourceHttpMessageWriter(BodyInserter.Context context) {
        return context.messageWriters().get().filter(messageWriter -> messageWriter.canWrite(RESOURCE_TYPE, null)).findFirst().map(BodyInserters::cast).orElseThrow(() -> new IllegalStateException("Could not find HttpMessageWriter that supports Resource objects"));
    }

    public static <T, S extends Publisher<ServerSentEvent<T>>> BodyInserter<S, ServerHttpResponse> fromServerSentEvents(S eventsPublisher) {
        Assert.notNull(eventsPublisher, (String)"'eventsPublisher' must not be null");
        return (serverResponse, context) -> {
            HttpMessageWriter messageWriter = BodyInserters.findMessageWriter(context, SERVER_SIDE_EVENT_TYPE, MediaType.TEXT_EVENT_STREAM);
            return context.serverRequest().map(serverRequest -> messageWriter.write(eventsPublisher, SERVER_SIDE_EVENT_TYPE, SERVER_SIDE_EVENT_TYPE, MediaType.TEXT_EVENT_STREAM, serverRequest, serverResponse, context.hints())).orElseGet(() -> messageWriter.write(eventsPublisher, SERVER_SIDE_EVENT_TYPE, MediaType.TEXT_EVENT_STREAM, serverResponse, context.hints()));
        };
    }

    public static <T, S extends Publisher<T>> BodyInserter<S, ServerHttpResponse> fromServerSentEvents(S eventsPublisher, Class<T> eventClass) {
        Assert.notNull(eventsPublisher, (String)"'eventsPublisher' must not be null");
        Assert.notNull(eventClass, (String)"'eventClass' must not be null");
        return BodyInserters.fromServerSentEvents(eventsPublisher, ResolvableType.forClass(eventClass));
    }

    public static <T, S extends Publisher<T>> BodyInserter<S, ServerHttpResponse> fromServerSentEvents(S eventsPublisher, ResolvableType eventType) {
        Assert.notNull(eventsPublisher, (String)"'eventsPublisher' must not be null");
        Assert.notNull((Object)eventType, (String)"'eventType' must not be null");
        return (serverResponse, context) -> {
            HttpMessageWriter messageWriter = BodyInserters.findMessageWriter(context, SERVER_SIDE_EVENT_TYPE, MediaType.TEXT_EVENT_STREAM);
            return context.serverRequest().map(serverRequest -> messageWriter.write(eventsPublisher, eventType, eventType, MediaType.TEXT_EVENT_STREAM, serverRequest, serverResponse, context.hints())).orElseGet(() -> messageWriter.write(eventsPublisher, eventType, MediaType.TEXT_EVENT_STREAM, serverResponse, context.hints()));
        };
    }

    public static BodyInserter<MultiValueMap<String, String>, ClientHttpRequest> fromFormData(MultiValueMap<String, String> formData) {
        Assert.notNull(formData, (String)"'formData' must not be null");
        return (outputMessage, context) -> {
            HttpMessageWriter messageWriter = BodyInserters.findMessageWriter(context, FORM_TYPE, MediaType.APPLICATION_FORM_URLENCODED);
            return messageWriter.write((Publisher)Mono.just((Object)formData), FORM_TYPE, MediaType.APPLICATION_FORM_URLENCODED, outputMessage, context.hints());
        };
    }

    public static BodyInserter<MultiValueMap<String, ?>, ClientHttpRequest> fromMultipartData(MultiValueMap<String, ?> multipartData) {
        Assert.notNull(multipartData, (String)"'multipartData' must not be null");
        return (outputMessage, context) -> {
            HttpMessageWriter messageWriter = BodyInserters.findMessageWriter(context, MULTIPART_VALUE_TYPE, MediaType.MULTIPART_FORM_DATA);
            return messageWriter.write((Publisher)Mono.just((Object)multipartData), FORM_TYPE, MediaType.MULTIPART_FORM_DATA, outputMessage, context.hints());
        };
    }

    public static <T extends Publisher<DataBuffer>> BodyInserter<T, ReactiveHttpOutputMessage> fromDataBuffers(T publisher) {
        Assert.notNull(publisher, (String)"'publisher' must not be null");
        return (outputMessage, context) -> outputMessage.writeWith(publisher);
    }

    private static <T, P extends Publisher<?>, M extends ReactiveHttpOutputMessage> BodyInserter<T, M> bodyInserterFor(P body, ResolvableType bodyType) {
        return (outputMessage, context) -> {
            MediaType contentType2 = outputMessage.getHeaders().getContentType();
            Supplier<Stream<HttpMessageWriter<?>>> messageWriters = context.messageWriters();
            return messageWriters.get().filter(messageWriter -> messageWriter.canWrite(bodyType, contentType2)).findFirst().map(BodyInserters::cast).map(messageWriter -> {
                Optional<ServerHttpRequest> serverRequest = context.serverRequest();
                if (serverRequest.isPresent() && outputMessage instanceof ServerHttpResponse) {
                    return messageWriter.write(body, bodyType, bodyType, contentType2, serverRequest.get(), (ServerHttpResponse)outputMessage, context.hints());
                }
                return messageWriter.write(body, bodyType, contentType2, outputMessage, context.hints());
            }).orElseGet(() -> {
                List<MediaType> supportedMediaTypes = ((Stream)messageWriters.get()).flatMap(reader -> reader.getWritableMediaTypes().stream()).collect(Collectors.toList());
                UnsupportedMediaTypeException error = new UnsupportedMediaTypeException(contentType2, supportedMediaTypes);
                return Mono.error((Throwable)((Object)error));
            });
        };
    }

    private static <T> HttpMessageWriter<T> findMessageWriter(BodyInserter.Context context, ResolvableType type, MediaType mediaType) {
        return context.messageWriters().get().filter(messageWriter -> messageWriter.canWrite(type, mediaType)).findFirst().map(BodyInserters::cast).orElseThrow(() -> new IllegalStateException("Could not find HttpMessageWriter that supports " + mediaType));
    }

    private static <T> HttpMessageWriter<T> cast(HttpMessageWriter<?> messageWriter) {
        return messageWriter;
    }
}

