/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.net.URI;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.client.DefaultClientRequestBuilder;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import reactor.core.publisher.Mono;

public interface ClientRequest {
    public HttpMethod method();

    public URI url();

    public HttpHeaders headers();

    public MultiValueMap<String, String> cookies();

    public BodyInserter<?, ? super ClientHttpRequest> body();

    public Mono<Void> writeTo(ClientHttpRequest var1, ExchangeStrategies var2);

    public static Builder from(ClientRequest other) {
        Assert.notNull((Object)other, (String)"'other' must not be null");
        return new DefaultClientRequestBuilder(other.method(), other.url()).headers(other.headers()).cookies(other.cookies()).body(other.body());
    }

    public static Builder method(HttpMethod method2, URI url) {
        return new DefaultClientRequestBuilder(method2, url);
    }

    public static interface Builder {
        public Builder header(String var1, String ... var2);

        public Builder headers(HttpHeaders var1);

        public Builder cookie(String var1, String var2);

        public Builder cookies(MultiValueMap<String, String> var1);

        public Builder body(BodyInserter<?, ? super ClientHttpRequest> var1);

        public <S, P extends Publisher<S>> Builder body(P var1, Class<S> var2);

        public ClientRequest build();
    }
}

