/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.net.URI;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientException;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultWebClient
implements WebClient {
    private final ExchangeFunction exchangeFunction;
    private final UriBuilderFactory uriBuilderFactory;
    private final HttpHeaders defaultHeaders;
    private final MultiValueMap<String, String> defaultCookies;

    DefaultWebClient(ExchangeFunction exchangeFunction, UriBuilderFactory factory, HttpHeaders defaultHeaders, MultiValueMap<String, String> defaultCookies) {
        this.exchangeFunction = exchangeFunction;
        this.uriBuilderFactory = factory != null ? factory : new DefaultUriBuilderFactory();
        this.defaultHeaders = defaultHeaders != null ? HttpHeaders.readOnlyHttpHeaders((HttpHeaders)defaultHeaders) : null;
        this.defaultCookies = defaultCookies != null ? CollectionUtils.unmodifiableMultiValueMap(defaultCookies) : null;
    }

    @Override
    public WebClient.UriSpec<WebClient.RequestHeadersSpec<?>> get() {
        return this.methodInternal(HttpMethod.GET);
    }

    @Override
    public WebClient.UriSpec<WebClient.RequestHeadersSpec<?>> head() {
        return this.methodInternal(HttpMethod.HEAD);
    }

    @Override
    public WebClient.UriSpec<WebClient.RequestBodySpec> post() {
        return this.methodInternal(HttpMethod.POST);
    }

    @Override
    public WebClient.UriSpec<WebClient.RequestBodySpec> put() {
        return this.methodInternal(HttpMethod.PUT);
    }

    @Override
    public WebClient.UriSpec<WebClient.RequestBodySpec> patch() {
        return this.methodInternal(HttpMethod.PATCH);
    }

    @Override
    public WebClient.UriSpec<WebClient.RequestHeadersSpec<?>> delete() {
        return this.methodInternal(HttpMethod.DELETE);
    }

    @Override
    public WebClient.UriSpec<WebClient.RequestHeadersSpec<?>> options() {
        return this.methodInternal(HttpMethod.OPTIONS);
    }

    @Override
    public WebClient.UriSpec<WebClient.RequestBodySpec> method(HttpMethod httpMethod) {
        return this.methodInternal(httpMethod);
    }

    private <S extends WebClient.RequestHeadersSpec<?>> WebClient.UriSpec<S> methodInternal(HttpMethod httpMethod) {
        return new DefaultUriSpec(httpMethod);
    }

    @Override
    public WebClient filter(ExchangeFilterFunction filterFunction) {
        ExchangeFunction filteredExchangeFunction = this.exchangeFunction.filter(filterFunction);
        return new DefaultWebClient(filteredExchangeFunction, this.uriBuilderFactory, this.defaultHeaders, this.defaultCookies);
    }

    private static class DefaultResponseSpec
    implements WebClient.ResponseSpec {
        private final Mono<ClientResponse> responseMono;

        DefaultResponseSpec(Mono<ClientResponse> responseMono) {
            this.responseMono = responseMono;
        }

        @Override
        public <T> Mono<T> bodyToMono(Class<T> bodyType) {
            return this.responseMono.flatMap(response -> this.bodyToPublisher((ClientResponse)response, BodyExtractors.toMono(bodyType), Mono::error));
        }

        @Override
        public <T> Flux<T> bodyToFlux(Class<T> elementType) {
            return this.responseMono.flatMapMany(response -> this.bodyToPublisher((ClientResponse)response, BodyExtractors.toFlux(elementType), Flux::error));
        }

        private <T extends Publisher<?>> T bodyToPublisher(ClientResponse response, BodyExtractor<T, ? super ClientHttpResponse> extractor, Function<WebClientException, T> errorFunction) {
            HttpStatus status = response.statusCode();
            if (status.is4xxClientError() || status.is5xxServerError()) {
                WebClientException ex = new WebClientException("ClientResponse has erroneous status code: " + status.value() + " " + status.getReasonPhrase());
                return (T)((Publisher)errorFunction.apply(ex));
            }
            return (T)((Publisher)response.body(extractor));
        }

        @Override
        public <T> Mono<ResponseEntity<T>> toEntity(Class<T> bodyType) {
            return this.responseMono.flatMap(response -> response.bodyToMono(bodyType).map(body -> {
                HttpHeaders headers2 = response.headers().asHttpHeaders();
                return new ResponseEntity(body, (MultiValueMap)headers2, response.statusCode());
            }));
        }

        @Override
        public <T> Mono<ResponseEntity<List<T>>> toEntityList(Class<T> responseType) {
            return this.responseMono.flatMap(response -> response.bodyToFlux(responseType).collectList().map(body -> {
                HttpHeaders headers2 = response.headers().asHttpHeaders();
                return new ResponseEntity(body, (MultiValueMap)headers2, response.statusCode());
            }));
        }
    }

    private class DefaultRequestBodySpec
    implements WebClient.RequestBodySpec {
        private final HttpMethod httpMethod;
        private final URI uri;
        private HttpHeaders headers;
        private MultiValueMap<String, String> cookies;
        private BodyInserter<?, ? super ClientHttpRequest> inserter;

        DefaultRequestBodySpec(HttpMethod httpMethod, URI uri) {
            this.httpMethod = httpMethod;
            this.uri = uri;
        }

        private HttpHeaders getHeaders() {
            if (this.headers == null) {
                this.headers = new HttpHeaders();
            }
            return this.headers;
        }

        private MultiValueMap<String, String> getCookies() {
            if (this.cookies == null) {
                this.cookies = new LinkedMultiValueMap(4);
            }
            return this.cookies;
        }

        @Override
        public DefaultRequestBodySpec header(String headerName, String ... headerValues) {
            for (String headerValue : headerValues) {
                this.getHeaders().add(headerName, headerValue);
            }
            return this;
        }

        @Override
        public DefaultRequestBodySpec headers(HttpHeaders headers2) {
            if (headers2 != null) {
                this.getHeaders().putAll((Map)headers2);
            }
            return this;
        }

        @Override
        public DefaultRequestBodySpec accept(MediaType ... acceptableMediaTypes) {
            this.getHeaders().setAccept(Arrays.asList(acceptableMediaTypes));
            return this;
        }

        @Override
        public DefaultRequestBodySpec acceptCharset(Charset ... acceptableCharsets) {
            this.getHeaders().setAcceptCharset(Arrays.asList(acceptableCharsets));
            return this;
        }

        @Override
        public DefaultRequestBodySpec contentType(MediaType contentType2) {
            this.getHeaders().setContentType(contentType2);
            return this;
        }

        @Override
        public DefaultRequestBodySpec contentLength(long contentLength) {
            this.getHeaders().setContentLength(contentLength);
            return this;
        }

        @Override
        public DefaultRequestBodySpec cookie(String name, String value) {
            this.getCookies().add((Object)name, (Object)value);
            return this;
        }

        @Override
        public DefaultRequestBodySpec cookies(MultiValueMap<String, String> cookies) {
            if (cookies != null) {
                this.getCookies().putAll(cookies);
            }
            return this;
        }

        @Override
        public DefaultRequestBodySpec ifModifiedSince(ZonedDateTime ifModifiedSince) {
            ZonedDateTime gmt = ifModifiedSince.withZoneSameInstant(ZoneId.of("GMT"));
            String headerValue = DateTimeFormatter.RFC_1123_DATE_TIME.format(gmt);
            this.getHeaders().set("If-Modified-Since", headerValue);
            return this;
        }

        @Override
        public DefaultRequestBodySpec ifNoneMatch(String ... ifNoneMatches) {
            this.getHeaders().setIfNoneMatch(Arrays.asList(ifNoneMatches));
            return this;
        }

        @Override
        public WebClient.RequestHeadersSpec<?> body(BodyInserter<?, ? super ClientHttpRequest> inserter) {
            this.inserter = inserter;
            return this;
        }

        @Override
        public <T, P extends Publisher<T>> WebClient.RequestHeadersSpec<?> body(P publisher, Class<T> elementClass) {
            this.inserter = BodyInserters.fromPublisher(publisher, elementClass);
            return this;
        }

        @Override
        public WebClient.RequestHeadersSpec<?> syncBody(Object body) {
            Assert.isTrue((!(body instanceof Publisher) ? 1 : 0) != 0, (String)"Please specify the element class by using body(Publisher, Class)");
            this.inserter = BodyInserters.fromObject(body);
            return this;
        }

        @Override
        public Mono<ClientResponse> exchange() {
            ClientRequest request = this.inserter != null ? this.initRequestBuilder().body(this.inserter).build() : this.initRequestBuilder().build();
            return DefaultWebClient.this.exchangeFunction.exchange(request);
        }

        private ClientRequest.Builder initRequestBuilder() {
            return ClientRequest.method(this.httpMethod, this.uri).headers(this.initHeaders()).cookies(this.initCookies());
        }

        private HttpHeaders initHeaders() {
            if (CollectionUtils.isEmpty((Map)DefaultWebClient.this.defaultHeaders) && CollectionUtils.isEmpty((Map)this.headers)) {
                return null;
            }
            if (CollectionUtils.isEmpty((Map)DefaultWebClient.this.defaultHeaders)) {
                return this.headers;
            }
            if (CollectionUtils.isEmpty((Map)this.headers)) {
                return DefaultWebClient.this.defaultHeaders;
            }
            HttpHeaders result = new HttpHeaders();
            result.putAll((Map)this.headers);
            DefaultWebClient.this.defaultHeaders.forEach((name, values) -> {
                if (!this.headers.containsKey(name)) {
                    values.forEach(value -> result.add(name, value));
                }
            });
            return result;
        }

        private MultiValueMap<String, String> initCookies() {
            if (CollectionUtils.isEmpty((Map)DefaultWebClient.this.defaultCookies) && CollectionUtils.isEmpty(this.cookies)) {
                return null;
            }
            if (CollectionUtils.isEmpty((Map)DefaultWebClient.this.defaultCookies)) {
                return this.cookies;
            }
            if (CollectionUtils.isEmpty(this.cookies)) {
                return DefaultWebClient.this.defaultCookies;
            }
            LinkedMultiValueMap result = new LinkedMultiValueMap();
            result.putAll(this.cookies);
            DefaultWebClient.this.defaultCookies.forEach((arg_0, arg_1) -> ((MultiValueMap)result).putIfAbsent(arg_0, arg_1));
            return result;
        }

        @Override
        public WebClient.ResponseSpec retrieve() {
            return new DefaultResponseSpec(this.exchange());
        }
    }

    private class DefaultUriSpec<S extends WebClient.RequestHeadersSpec<?>>
    implements WebClient.UriSpec<S> {
        private final HttpMethod httpMethod;

        DefaultUriSpec(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public S uri(String uriTemplate, Object ... uriVariables) {
            return this.uri(DefaultWebClient.this.uriBuilderFactory.expand(uriTemplate, uriVariables));
        }

        @Override
        public S uri(String uriTemplate, Map<String, ?> uriVariables) {
            return this.uri(DefaultWebClient.this.uriBuilderFactory.expand(uriTemplate, uriVariables));
        }

        @Override
        public S uri(Function<UriBuilder, URI> uriFunction) {
            return this.uri(uriFunction.apply(DefaultWebClient.this.uriBuilderFactory.builder()));
        }

        @Override
        public S uri(URI uri) {
            return (S)new DefaultRequestBodySpec(this.httpMethod, uri);
        }
    }
}

