/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.function.server.DefaultServerRequest;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.PathResourceLookupFunction;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.ResourceHandlerFunction;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.adapter.HttpWebHandlerAdapter;
import reactor.core.publisher.Mono;

public abstract class RouterFunctions {
    private static final Log logger = LogFactory.getLog(RouterFunctions.class);
    public static final String REQUEST_ATTRIBUTE = RouterFunctions.class.getName() + ".request";
    public static final String URI_TEMPLATE_VARIABLES_ATTRIBUTE = RouterFunctions.class.getName() + ".uriTemplateVariables";
    private static final HandlerFunction<ServerResponse> NOT_FOUND_HANDLER = request -> ServerResponse.notFound().build();

    public static <T extends ServerResponse> RouterFunction<T> route(RequestPredicate predicate, HandlerFunction<T> handlerFunction) {
        Assert.notNull((Object)predicate, (String)"'predicate' must not be null");
        Assert.notNull(handlerFunction, (String)"'handlerFunction' must not be null");
        return request -> {
            if (predicate.test(request)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Predicate \"%s\" matches against \"%s\"", predicate, request));
                }
                return Mono.just((Object)handlerFunction);
            }
            return Mono.empty();
        };
    }

    public static <T extends ServerResponse> RouterFunction<T> nest(RequestPredicate predicate, RouterFunction<T> routerFunction) {
        Assert.notNull((Object)predicate, (String)"'predicate' must not be null");
        Assert.notNull(routerFunction, (String)"'routerFunction' must not be null");
        return request -> predicate.nest(request).map(nestedRequest -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Nested predicate \"%s\" matches against \"%s\"", predicate, request));
            }
            return routerFunction.route((ServerRequest)nestedRequest);
        }).orElseGet(Mono::empty);
    }

    public static RouterFunction<ServerResponse> resources(String pattern, Resource location) {
        Assert.hasLength((String)pattern, (String)"'pattern' must not be empty");
        Assert.notNull((Object)location, (String)"'location' must not be null");
        return RouterFunctions.resources(new PathResourceLookupFunction(pattern, location));
    }

    public static RouterFunction<ServerResponse> resources(Function<ServerRequest, Mono<Resource>> lookupFunction) {
        Assert.notNull(lookupFunction, (String)"'lookupFunction' must not be null");
        return request -> ((Mono)lookupFunction.apply(request)).map(ResourceHandlerFunction::new);
    }

    public static HttpWebHandlerAdapter toHttpHandler(RouterFunction<?> routerFunction) {
        return RouterFunctions.toHttpHandler(routerFunction, HandlerStrategies.withDefaults());
    }

    public static HttpWebHandlerAdapter toHttpHandler(RouterFunction<?> routerFunction, HandlerStrategies strategies) {
        Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
        Assert.notNull((Object)strategies, (String)"HandlerStrategies must not be null");
        return new HttpWebHandlerAdapter(exchange -> {
            DefaultServerRequest request = new DefaultServerRequest(exchange, strategies);
            RouterFunctions.addAttributes(exchange, request);
            return routerFunction.route(request).defaultIfEmpty(RouterFunctions.notFound()).flatMap(handlerFunction -> RouterFunctions.wrapException(() -> handlerFunction.handle(request))).flatMap(response -> RouterFunctions.wrapException(() -> response.writeTo(exchange, strategies))).onErrorResume(ResponseStatusException.class, ex -> {
                exchange.getResponse().setStatusCode(ex.getStatus());
                if (ex.getMessage() != null) {
                    logger.error((Object)ex.getMessage());
                }
                return Mono.empty();
            });
        });
    }

    private static <T> Mono<T> wrapException(Supplier<Mono<T>> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            return Mono.error((Throwable)t);
        }
    }

    public static HandlerMapping toHandlerMapping(RouterFunction<?> routerFunction) {
        return RouterFunctions.toHandlerMapping(routerFunction, HandlerStrategies.withDefaults());
    }

    public static HandlerMapping toHandlerMapping(RouterFunction<?> routerFunction, HandlerStrategies strategies) {
        Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
        Assert.notNull((Object)strategies, (String)"HandlerStrategies must not be null");
        return exchange -> {
            DefaultServerRequest request = new DefaultServerRequest(exchange, strategies);
            RouterFunctions.addAttributes(exchange, request);
            return routerFunction.route(request).map(handlerFunction -> handlerFunction);
        };
    }

    private static void addAttributes(ServerWebExchange exchange, ServerRequest request) {
        Map attributes = exchange.getAttributes();
        attributes.put(REQUEST_ATTRIBUTE, request);
    }

    private static <T extends ServerResponse> HandlerFunction<T> notFound() {
        return NOT_FOUND_HANDLER;
    }

    static <T extends ServerResponse> HandlerFunction<T> cast(HandlerFunction<?> handlerFunction) {
        return handlerFunction;
    }
}

