/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.codec.DecodingException;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageReaderArgumentResolver
extends HandlerMethodArgumentResolverSupport {
    private final List<HttpMessageReader<?>> messageReaders;
    private final List<MediaType> supportedMediaTypes;

    protected AbstractMessageReaderArgumentResolver(List<HttpMessageReader<?>> readers) {
        this(readers, new ReactiveAdapterRegistry());
    }

    protected AbstractMessageReaderArgumentResolver(List<HttpMessageReader<?>> messageReaders, ReactiveAdapterRegistry adapterRegistry) {
        super(adapterRegistry);
        Assert.notEmpty(messageReaders, (String)"At least one HttpMessageReader is required");
        Assert.notNull((Object)adapterRegistry, (String)"ReactiveAdapterRegistry is required");
        this.messageReaders = messageReaders;
        this.supportedMediaTypes = messageReaders.stream().flatMap(converter -> converter.getReadableMediaTypes().stream()).collect(Collectors.toList());
    }

    public List<HttpMessageReader<?>> getMessageReaders() {
        return this.messageReaders;
    }

    protected Mono<Object> readBody(MethodParameter bodyParameter, boolean isBodyRequired, BindingContext bindingContext, ServerWebExchange exchange) {
        ResolvableType bodyType = ResolvableType.forMethodParameter((MethodParameter)bodyParameter);
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(bodyType.resolve());
        ResolvableType elementType = adapter != null ? bodyType.getGeneric(new int[]{0}) : bodyType;
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        MediaType mediaType = request.getHeaders().getContentType();
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM;
        }
        for (HttpMessageReader<?> reader : this.getMessageReaders()) {
            Object[] hints;
            if (!reader.canRead(elementType, mediaType)) continue;
            Map readHints = Collections.emptyMap();
            if (adapter != null && adapter.isMultiValue()) {
                Object[] hints2;
                Flux flux = reader.read(bodyType, elementType, request, response, readHints);
                flux = flux.onErrorResume(ex -> Flux.error((Throwable)this.handleReadError(bodyParameter, (Throwable)ex)));
                if (isBodyRequired || !adapter.supportsEmpty()) {
                    flux = flux.switchIfEmpty((Publisher)Flux.error((Throwable)this.handleMissingBody(bodyParameter)));
                }
                if ((hints2 = this.extractValidationHints(bodyParameter)) != null) {
                    flux = flux.doOnNext(target -> this.validate(target, hints2, bodyParameter, bindingContext, exchange));
                }
                return Mono.just((Object)adapter.fromPublisher((Publisher)flux));
            }
            Mono mono = reader.readMono(bodyType, elementType, request, response, readHints);
            mono = mono.onErrorResume(ex -> Mono.error((Throwable)this.handleReadError(bodyParameter, (Throwable)ex)));
            if (isBodyRequired || adapter != null && !adapter.supportsEmpty()) {
                mono = mono.switchIfEmpty(Mono.error((Throwable)this.handleMissingBody(bodyParameter)));
            }
            if ((hints = this.extractValidationHints(bodyParameter)) != null) {
                mono = mono.doOnNext(target -> this.validate(target, hints, bodyParameter, bindingContext, exchange));
            }
            if (adapter != null) {
                return Mono.just((Object)adapter.fromPublisher((Publisher)mono));
            }
            return Mono.from((Publisher)mono);
        }
        return Mono.error((Throwable)new UnsupportedMediaTypeStatusException(mediaType, this.supportedMediaTypes));
    }

    private Throwable handleReadError(MethodParameter parameter, Throwable ex) {
        return ex instanceof DecodingException ? new ServerWebInputException("Failed to read HTTP message", parameter, ex) : ex;
    }

    private ServerWebInputException handleMissingBody(MethodParameter param) {
        return new ServerWebInputException("Request body is missing: " + param.getMethod().toGenericString());
    }

    private Object[] extractValidationHints(MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation ann : annotations = parameter.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validatedAnn = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validatedAnn == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validatedAnn != null ? validatedAnn.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            return objectArray;
        }
        return null;
    }

    private void validate(Object target, Object[] validationHints, MethodParameter param, BindingContext binding, ServerWebExchange exchange) {
        String name = Conventions.getVariableNameForParameter((MethodParameter)param);
        WebExchangeDataBinder binder = binding.createDataBinder(exchange, target, name);
        binder.validate(validationHints);
        if (binder.getBindingResult().hasErrors()) {
            throw new WebExchangeBindException(param, binder.getBindingResult());
        }
    }
}

