/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeanUtils;
import org.springframework.core.Conventions;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public class ModelAttributeMethodArgumentResolver
extends HandlerMethodArgumentResolverSupport {
    private static final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private final boolean useDefaultResolution;

    public ModelAttributeMethodArgumentResolver(ReactiveAdapterRegistry adapterRegistry, boolean useDefaultResolution) {
        super(adapterRegistry);
        this.useDefaultResolution = useDefaultResolution;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(ModelAttribute.class)) {
            return true;
        }
        if (this.useDefaultResolution) {
            return this.checkParameterType(parameter, type -> !BeanUtils.isSimpleProperty((Class)type));
        }
        return false;
    }

    @Override
    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext context, ServerWebExchange exchange) {
        ResolvableType type = ResolvableType.forMethodParameter((MethodParameter)parameter);
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(type.resolve());
        ResolvableType valueType = adapter != null ? type.getGeneric(new int[]{0}) : type;
        Assert.state((adapter == null || !adapter.isMultiValue() ? 1 : 0) != 0, () -> this.getClass().getSimpleName() + " doesn't support multi-value reactive type wrapper: " + parameter.getGenericParameterType());
        String name = this.getAttributeName(parameter);
        Mono<?> valueMono = this.prepareAttributeMono(name, valueType, context, exchange);
        Map model = context.getModel().asMap();
        MonoProcessor bindingResultMono = MonoProcessor.create();
        model.put(BindingResult.MODEL_KEY_PREFIX + name, bindingResultMono);
        return valueMono.flatMap(value -> {
            WebExchangeDataBinder binder = context.createDataBinder(exchange, value, name);
            return binder.bind(exchange).doOnError(arg_0 -> ((MonoProcessor)bindingResultMono).onError(arg_0)).doOnSuccess(aVoid -> {
                this.validateIfApplicable(binder, parameter);
                BindingResult errors = binder.getBindingResult();
                model.put(BindingResult.MODEL_KEY_PREFIX + name, errors);
                model.put(name, value);
                bindingResultMono.onNext((Object)errors);
            }).then(Mono.fromCallable(() -> {
                BindingResult errors = binder.getBindingResult();
                if (adapter != null) {
                    return adapter.fromPublisher((Publisher)(errors.hasErrors() ? Mono.error((Throwable)new WebExchangeBindException(parameter, errors)) : valueMono));
                }
                if (errors.hasErrors() && !this.hasErrorsArgument(parameter)) {
                    throw new WebExchangeBindException(parameter, errors);
                }
                return value;
            }));
        });
    }

    private String getAttributeName(MethodParameter parameter) {
        return Optional.ofNullable(parameter.getParameterAnnotation(ModelAttribute.class)).filter(ann -> StringUtils.hasText((String)ann.value())).map(ModelAttribute::value).orElse(Conventions.getVariableNameForParameter((MethodParameter)parameter));
    }

    private Mono<?> prepareAttributeMono(String attributeName, ResolvableType attributeType, BindingContext context, ServerWebExchange exchange) {
        Object attribute = context.getModel().asMap().get(attributeName);
        if (attribute == null) {
            attribute = this.findAndRemoveReactiveAttribute(context.getModel(), attributeName);
        }
        if (attribute == null) {
            return this.createAttribute(attributeName, attributeType.getRawClass(), context, exchange);
        }
        ReactiveAdapter adapterFrom = this.getAdapterRegistry().getAdapter(null, attribute);
        if (adapterFrom != null) {
            Assert.isTrue((!adapterFrom.isMultiValue() ? 1 : 0) != 0, (String)"Data binding only supports single-value async types");
            return Mono.from((Publisher)adapterFrom.toPublisher(attribute));
        }
        return Mono.justOrEmpty(attribute);
    }

    private Object findAndRemoveReactiveAttribute(Model model, String attributeName) {
        return model.asMap().entrySet().stream().filter(entry -> {
            if (!((String)entry.getKey()).startsWith(attributeName)) {
                return false;
            }
            ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(null, entry.getValue());
            if (adapter == null) {
                return false;
            }
            String name = attributeName + ClassUtils.getShortName((Class)adapter.getReactiveType());
            return ((String)entry.getKey()).equals(name);
        }).findFirst().map(entry -> {
            model.asMap().remove(entry.getKey());
            return entry.getValue();
        }).orElse(null);
    }

    private Mono<?> createAttribute(String attributeName, Class<?> attributeType, BindingContext context, ServerWebExchange exchange) {
        Constructor<?>[] ctors = attributeType.getConstructors();
        if (ctors.length != 1) {
            return Mono.just((Object)BeanUtils.instantiateClass(attributeType));
        }
        Constructor<?> ctor = ctors[0];
        if (ctor.getParameterCount() == 0) {
            return Mono.just((Object)BeanUtils.instantiateClass(ctor, (Object[])new Object[0]));
        }
        return WebExchangeDataBinder.extractValuesToBind((ServerWebExchange)exchange).map(bindValues -> {
            ConstructorProperties cp = ctor.getAnnotation(ConstructorProperties.class);
            String[] paramNames = cp != null ? cp.value() : parameterNameDiscoverer.getParameterNames(ctor);
            Assert.state((paramNames != null ? 1 : 0) != 0, () -> "Cannot resolve parameter names for constructor " + ctor);
            Class<?>[] paramTypes = ctor.getParameterTypes();
            Assert.state((paramNames.length == paramTypes.length ? 1 : 0) != 0, () -> "Invalid number of parameter names: " + paramNames.length + " for constructor " + ctor);
            Object[] args = new Object[paramTypes.length];
            WebExchangeDataBinder binder = context.createDataBinder(exchange, null, attributeName);
            for (int i = 0; i < paramNames.length; ++i) {
                Object value = bindValues.get(paramNames[i]);
                value = value != null && value instanceof List ? ((List)value).toArray() : value;
                args[i] = binder.convertIfNecessary(value, paramTypes[i], new MethodParameter(ctor, i));
            }
            return BeanUtils.instantiateClass((Constructor)ctor, (Object[])args);
        });
    }

    private boolean hasErrorsArgument(MethodParameter parameter) {
        int i = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getMethod().getParameterTypes();
        return paramTypes.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
    }

    private void validateIfApplicable(WebExchangeDataBinder binder, MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation ann : annotations = parameter.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validAnnot = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validAnnot == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validAnnot != null ? validAnnot.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] hintArray = objectArray;
            binder.validate(new Object[]{hintArray});
        }
    }
}

