/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.InvocableHandlerMethod;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.reactive.result.method.annotation.ControllerMethodResolver;
import org.springframework.web.reactive.result.method.annotation.InitBinderBindingContext;
import org.springframework.web.reactive.result.method.annotation.ModelInitializer;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RequestMappingHandlerAdapter
implements HandlerAdapter,
ApplicationContextAware,
InitializingBean {
    private static final Log logger = LogFactory.getLog(RequestMappingHandlerAdapter.class);
    private ServerCodecConfigurer messageCodecConfigurer;
    private WebBindingInitializer webBindingInitializer;
    private ArgumentResolverConfigurer argumentResolverConfigurer;
    private ReactiveAdapterRegistry reactiveAdapterRegistry;
    private ConfigurableApplicationContext applicationContext;
    private ControllerMethodResolver methodResolver;
    private ModelInitializer modelInitializer;

    public void setMessageCodecConfigurer(ServerCodecConfigurer configurer) {
        this.messageCodecConfigurer = configurer;
    }

    public ServerCodecConfigurer getMessageCodecConfigurer() {
        return this.messageCodecConfigurer;
    }

    public void setWebBindingInitializer(WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    public WebBindingInitializer getWebBindingInitializer() {
        return this.webBindingInitializer;
    }

    public void setArgumentResolverConfigurer(ArgumentResolverConfigurer configurer) {
        Assert.notNull((Object)configurer, (String)"ArgumentResolverConfigurer is required");
        this.argumentResolverConfigurer = configurer;
    }

    public ArgumentResolverConfigurer getArgumentResolverConfigurer() {
        return this.argumentResolverConfigurer;
    }

    public void setReactiveAdapterRegistry(ReactiveAdapterRegistry registry) {
        this.reactiveAdapterRegistry = registry;
    }

    public ReactiveAdapterRegistry getReactiveAdapterRegistry() {
        return this.reactiveAdapterRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.messageCodecConfigurer == null) {
            this.messageCodecConfigurer = ServerCodecConfigurer.create();
        }
        if (this.argumentResolverConfigurer == null) {
            this.argumentResolverConfigurer = new ArgumentResolverConfigurer();
        }
        if (this.reactiveAdapterRegistry == null) {
            this.reactiveAdapterRegistry = new ReactiveAdapterRegistry();
        }
        this.methodResolver = new ControllerMethodResolver(this.argumentResolverConfigurer, this.messageCodecConfigurer, this.reactiveAdapterRegistry, this.applicationContext);
        this.modelInitializer = new ModelInitializer(this.reactiveAdapterRegistry);
    }

    @Override
    public boolean supports(Object handler) {
        return HandlerMethod.class.equals(handler.getClass());
    }

    @Override
    public Mono<HandlerResult> handle(ServerWebExchange exchange, Object handler) {
        Assert.notNull((Object)handler, (String)"Expected handler");
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        InitBinderBindingContext bindingContext = new InitBinderBindingContext(this.getWebBindingInitializer(), this.methodResolver.getInitBinderMethods(handlerMethod));
        List<InvocableHandlerMethod> modelAttributeMethods = this.methodResolver.getModelAttributeMethods(handlerMethod);
        Function<Throwable, Mono> exceptionHandler = ex -> this.handleException((Throwable)ex, handlerMethod, bindingContext, exchange);
        return this.modelInitializer.initModel(bindingContext, modelAttributeMethods, exchange).then(Mono.defer(() -> this.methodResolver.getRequestMappingMethod(handlerMethod).invoke(exchange, bindingContext, new Object[0]).doOnNext(result -> result.setExceptionHandler(exceptionHandler)).onErrorResume(exceptionHandler)));
    }

    private Mono<HandlerResult> handleException(Throwable ex, HandlerMethod handlerMethod, BindingContext bindingContext, ServerWebExchange exchange) {
        return this.methodResolver.getExceptionHandlerMethod(ex, handlerMethod).map(invocable -> {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Invoking @ExceptionHandler method: " + invocable.getMethod()));
                }
                bindingContext.getModel().asMap().clear();
                Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                return invocable.invoke(exchange, bindingContext, cause, handlerMethod);
            }
            catch (Throwable invocationEx) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Failed to invoke: " + invocable.getMethod()), invocationEx);
                }
                return null;
            }
        }).orElseGet(() -> Mono.error((Throwable)ex));
    }
}

