/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.reactive.result.view.RequestContext;
import org.springframework.web.reactive.result.view.RequestDataValueProcessor;
import org.springframework.web.reactive.result.view.View;
import org.springframework.web.reactive.result.view.ViewResolverSupport;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractView
implements View,
ApplicationContextAware {
    public static final String REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME = "requestDataValueProcessor";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final Object NO_VALUE = new Object();
    private final List<MediaType> mediaTypes = new ArrayList<MediaType>(4);
    private final ReactiveAdapterRegistry adapterRegistry;
    private Charset defaultCharset = StandardCharsets.UTF_8;
    private String requestContextAttribute;
    private ApplicationContext applicationContext;

    public AbstractView() {
        this(new ReactiveAdapterRegistry());
    }

    public AbstractView(ReactiveAdapterRegistry registry) {
        this.mediaTypes.add(ViewResolverSupport.DEFAULT_CONTENT_TYPE);
        this.adapterRegistry = registry;
    }

    public void setSupportedMediaTypes(List<MediaType> supportedMediaTypes) {
        Assert.notEmpty(supportedMediaTypes, (String)"MediaType List must not be empty");
        this.mediaTypes.clear();
        if (supportedMediaTypes != null) {
            this.mediaTypes.addAll(supportedMediaTypes);
        }
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return this.mediaTypes;
    }

    public void setDefaultCharset(Charset defaultCharset) {
        Assert.notNull((Object)defaultCharset, (String)"'defaultCharset' must not be null");
        this.defaultCharset = defaultCharset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setRequestContextAttribute(String requestContextAttribute) {
        this.requestContextAttribute = requestContextAttribute;
    }

    public String getRequestContextAttribute() {
        return this.requestContextAttribute;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public Mono<Void> render(Map<String, ?> model, MediaType contentType2, ServerWebExchange exchange) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Rendering view with model " + model));
        }
        if (contentType2 != null) {
            exchange.getResponse().getHeaders().setContentType(contentType2);
        }
        return this.getModelAttributes(model, exchange).flatMap(mergedModel -> {
            if (this.requestContextAttribute != null) {
                mergedModel.put(this.requestContextAttribute, this.createRequestContext(exchange, (Map<String, Object>)mergedModel));
            }
            return this.renderInternal((Map<String, Object>)mergedModel, contentType2, exchange);
        });
    }

    protected Mono<Map<String, Object>> getModelAttributes(Map<String, ?> model, ServerWebExchange exchange) {
        int size = model != null ? model.size() : 0;
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>(size);
        if (model != null) {
            attributes.putAll(model);
        }
        return this.resolveAsyncAttributes(attributes).then(Mono.just(attributes));
    }

    protected Mono<Void> resolveAsyncAttributes(Map<String, Object> model) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Mono> valueMonos = new ArrayList<Mono>();
        for (Map.Entry<String, Object> entry : model.entrySet()) {
            ReactiveAdapter adapter;
            Object value = entry.getValue();
            if (value == null || (adapter = this.adapterRegistry.getAdapter(null, value)) == null) continue;
            names.add(entry.getKey());
            if (adapter.isMultiValue()) {
                Flux fluxValue = Flux.from((Publisher)adapter.toPublisher(value));
                valueMonos.add(fluxValue.collectList().defaultIfEmpty(Collections.emptyList()));
                continue;
            }
            Mono monoValue = Mono.from((Publisher)adapter.toPublisher(value));
            valueMonos.add(monoValue.defaultIfEmpty(NO_VALUE));
        }
        if (names.isEmpty()) {
            return Mono.empty();
        }
        return Mono.when(valueMonos, values -> {
            for (int i = 0; i < ((Object[])values).length; ++i) {
                if (values[i] != NO_VALUE) {
                    model.put((String)names.get(i), values[i]);
                    continue;
                }
                model.remove(names.get(i));
            }
            return NO_VALUE;
        }).then();
    }

    protected RequestContext createRequestContext(ServerWebExchange exchange, Map<String, Object> model) {
        return new RequestContext(exchange, model, (MessageSource)this.getApplicationContext(), this.getRequestDataValueProcessor());
    }

    protected RequestDataValueProcessor getRequestDataValueProcessor() {
        ApplicationContext context = this.getApplicationContext();
        if (context != null && context.containsBean(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME)) {
            return (RequestDataValueProcessor)context.getBean(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME, RequestDataValueProcessor.class);
        }
        return null;
    }

    protected abstract Mono<Void> renderInternal(Map<String, Object> var1, MediaType var2, ServerWebExchange var3);

    public String toString() {
        return this.getClass().getName();
    }
}

