/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view;

import java.util.Arrays;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.web.reactive.result.view.DefaultRendering;
import org.springframework.web.reactive.result.view.RedirectView;
import org.springframework.web.reactive.result.view.Rendering;

class DefaultRenderingBuilder
implements Rendering.RedirectBuilder {
    private final Object view;
    private Model model;
    private HttpStatus status;
    private HttpHeaders headers;

    DefaultRenderingBuilder(Object view) {
        this.view = view;
    }

    @Override
    public DefaultRenderingBuilder modelAttribute(String name, Object value) {
        this.initModel();
        this.model.addAttribute(name, value);
        return this;
    }

    private void initModel() {
        if (this.model == null) {
            this.model = new ExtendedModelMap();
        }
    }

    @Override
    public DefaultRenderingBuilder modelAttribute(Object value) {
        this.initModel();
        this.model.addAttribute(value);
        return this;
    }

    @Override
    public DefaultRenderingBuilder modelAttributes(Object ... values) {
        this.initModel();
        this.model.addAllAttributes(Arrays.asList(values));
        return this;
    }

    @Override
    public DefaultRenderingBuilder model(Map<String, ?> map) {
        this.initModel();
        this.model.addAllAttributes(map);
        return this;
    }

    @Override
    public DefaultRenderingBuilder status(HttpStatus status) {
        this.status = status;
        return this;
    }

    @Override
    public DefaultRenderingBuilder header(String headerName, String ... headerValues) {
        this.initHeaders();
        this.headers.put(headerName, Arrays.asList(headerValues));
        return this;
    }

    @Override
    public DefaultRenderingBuilder headers(HttpHeaders headers2) {
        this.initHeaders();
        this.headers.putAll((Map)headers2);
        return this;
    }

    private void initHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
        }
    }

    @Override
    public Rendering.RedirectBuilder contextRelative(boolean contextRelative) {
        this.getRedirectView().setContextRelative(contextRelative);
        return this;
    }

    @Override
    public Rendering.RedirectBuilder propagateQuery(boolean propagate) {
        this.getRedirectView().setPropagateQuery(propagate);
        return this;
    }

    private RedirectView getRedirectView() {
        Assert.isInstanceOf(RedirectView.class, (Object)this.view);
        return (RedirectView)this.view;
    }

    @Override
    public Rendering build() {
        return new DefaultRendering(this.view, this.model, this.status, this.headers);
    }
}

