/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractWebSocketSession<T>
implements WebSocketSession {
    private final T delegate;
    private final String id;
    private final HandshakeInfo handshakeInfo;
    private final DataBufferFactory bufferFactory;

    protected AbstractWebSocketSession(T delegate, String id, HandshakeInfo handshakeInfo, DataBufferFactory bufferFactory) {
        Assert.notNull(delegate, (String)"Native session is required.");
        Assert.notNull((Object)id, (String)"Session id is required.");
        Assert.notNull((Object)handshakeInfo, (String)"HandshakeInfo is required.");
        Assert.notNull((Object)bufferFactory, (String)"DataBuffer factory is required.");
        this.delegate = delegate;
        this.id = id;
        this.handshakeInfo = handshakeInfo;
        this.bufferFactory = bufferFactory;
    }

    protected T getDelegate() {
        return this.delegate;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public HandshakeInfo getHandshakeInfo() {
        return this.handshakeInfo;
    }

    @Override
    public Flux<WebSocketMessage> receive() {
        return null;
    }

    @Override
    public Mono<Void> send(Publisher<WebSocketMessage> messages) {
        return null;
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public WebSocketMessage textMessage(String payload) {
        byte[] bytes = payload.getBytes(StandardCharsets.UTF_8);
        DataBuffer buffer = this.bufferFactory().wrap(bytes);
        return new WebSocketMessage(WebSocketMessage.Type.TEXT, buffer);
    }

    @Override
    public WebSocketMessage binaryMessage(Function<DataBufferFactory, DataBuffer> payloadFactory) {
        DataBuffer payload = payloadFactory.apply(this.bufferFactory());
        return new WebSocketMessage(WebSocketMessage.Type.BINARY, payload);
    }

    @Override
    public WebSocketMessage pingMessage(Function<DataBufferFactory, DataBuffer> payloadFactory) {
        DataBuffer payload = payloadFactory.apply(this.bufferFactory());
        return new WebSocketMessage(WebSocketMessage.Type.PING, payload);
    }

    @Override
    public WebSocketMessage pongMessage(Function<DataBufferFactory, DataBuffer> payloadFactory) {
        DataBuffer payload = payloadFactory.apply(this.bufferFactory());
        return new WebSocketMessage(WebSocketMessage.Type.PONG, payload);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + ", uri=" + this.getHandshakeInfo().getUri() + "]";
    }
}

