/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultClientResponse
implements ClientResponse {
    private final ClientHttpResponse response;
    private final ClientResponse.Headers headers;
    private final ExchangeStrategies strategies;

    public DefaultClientResponse(ClientHttpResponse response, ExchangeStrategies strategies) {
        this.response = response;
        this.strategies = strategies;
        this.headers = new DefaultHeaders();
    }

    @Override
    public HttpStatus statusCode() {
        return this.response.getStatusCode();
    }

    @Override
    public ClientResponse.Headers headers() {
        return this.headers;
    }

    @Override
    public MultiValueMap<String, ResponseCookie> cookies() {
        return this.response.getCookies();
    }

    @Override
    public <T> T body(BodyExtractor<T, ? super ClientHttpResponse> extractor) {
        return extractor.extract((ClientHttpResponse)this.response, new BodyExtractor.Context(){

            @Override
            public List<HttpMessageReader<?>> messageReaders() {
                return DefaultClientResponse.this.strategies.messageReaders();
            }

            @Override
            public Optional<ServerHttpResponse> serverResponse() {
                return Optional.empty();
            }

            @Override
            public Map<String, Object> hints() {
                return Collections.emptyMap();
            }
        });
    }

    @Override
    public <T> Mono<T> bodyToMono(Class<? extends T> elementClass) {
        return this.body(BodyExtractors.toMono(elementClass));
    }

    @Override
    public <T> Flux<T> bodyToFlux(Class<? extends T> elementClass) {
        return this.body(BodyExtractors.toFlux(elementClass));
    }

    private class DefaultHeaders
    implements ClientResponse.Headers {
        private DefaultHeaders() {
        }

        private HttpHeaders delegate() {
            return DefaultClientResponse.this.response.getHeaders();
        }

        @Override
        public OptionalLong contentLength() {
            return this.toOptionalLong(this.delegate().getContentLength());
        }

        @Override
        public Optional<MediaType> contentType() {
            return Optional.ofNullable(this.delegate().getContentType());
        }

        @Override
        public List<String> header(String headerName) {
            List<String> headerValues = this.delegate().get((Object)headerName);
            return headerValues != null ? headerValues : Collections.emptyList();
        }

        @Override
        public HttpHeaders asHttpHeaders() {
            return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.delegate());
        }

        private OptionalLong toOptionalLong(long value) {
            return value != -1L ? OptionalLong.of(value) : OptionalLong.empty();
        }
    }
}

