/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server.support;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RouterFunctionMapping
extends AbstractHandlerMapping
implements InitializingBean {
    private RouterFunction<?> routerFunction;
    private ServerCodecConfigurer messageCodecConfigurer;

    public RouterFunctionMapping() {
    }

    public RouterFunctionMapping(RouterFunction<?> routerFunction) {
        this.routerFunction = routerFunction;
    }

    public void setMessageCodecConfigurer(ServerCodecConfigurer configurer) {
        this.messageCodecConfigurer = configurer;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.messageCodecConfigurer == null) {
            this.messageCodecConfigurer = ServerCodecConfigurer.create();
        }
        if (this.routerFunction == null) {
            this.initRouterFunctions();
        }
    }

    protected void initRouterFunctions() {
        List<RouterFunction<?>> routerFunctions;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for router functions in application context: " + this.getApplicationContext()));
        }
        if (!CollectionUtils.isEmpty(routerFunctions = this.routerFunctions()) && this.logger.isInfoEnabled()) {
            routerFunctions.forEach(routerFunction1 -> this.logger.info((Object)("Mapped " + routerFunction1)));
        }
        this.routerFunction = routerFunctions.stream().reduce(RouterFunction::andOther).orElse(null);
    }

    private List<RouterFunction<?>> routerFunctions() {
        SortedRouterFunctionsContainer container = new SortedRouterFunctionsContainer();
        this.obtainApplicationContext().getAutowireCapableBeanFactory().autowireBean((Object)container);
        return CollectionUtils.isEmpty((Collection)container.routerFunctions) ? Collections.emptyList() : container.routerFunctions;
    }

    @Override
    protected Mono<?> getHandlerInternal(ServerWebExchange exchange) {
        if (this.routerFunction != null) {
            ServerRequest request = ServerRequest.create(exchange, this.messageCodecConfigurer.getReaders());
            exchange.getAttributes().put(RouterFunctions.REQUEST_ATTRIBUTE, request);
            return this.routerFunction.route(request);
        }
        return Mono.empty();
    }

    private static class SortedRouterFunctionsContainer {
        private List<RouterFunction<?>> routerFunctions;

        private SortedRouterFunctionsContainer() {
        }

        @Autowired(required=false)
        public void setRouterFunctions(List<RouterFunction<?>> routerFunctions) {
            this.routerFunctions = routerFunctions;
        }
    }
}

