/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server.support;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.util.Assert;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.HandlerResultHandler;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ServerResponseResultHandler
implements HandlerResultHandler,
InitializingBean,
Ordered {
    private ServerCodecConfigurer messageCodecConfigurer;
    private List<ViewResolver> viewResolvers;
    private int order = Integer.MAX_VALUE;

    public void setMessageCodecConfigurer(ServerCodecConfigurer configurer) {
        this.messageCodecConfigurer = configurer;
    }

    public void setViewResolvers(List<ViewResolver> viewResolvers) {
        this.viewResolvers = viewResolvers;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.messageCodecConfigurer == null) {
            throw new IllegalArgumentException("'messageCodecConfigurer' is required");
        }
        if (this.viewResolvers == null) {
            this.viewResolvers = Collections.emptyList();
        }
    }

    @Override
    public boolean supports(HandlerResult result) {
        return result.getReturnValue() instanceof ServerResponse;
    }

    @Override
    public Mono<Void> handleResult(ServerWebExchange exchange, HandlerResult result) {
        ServerResponse response = (ServerResponse)result.getReturnValue();
        Assert.state((response != null ? 1 : 0) != 0, (String)"No ServerResponse");
        return response.writeTo(exchange, new ServerResponse.Context(){

            @Override
            public List<HttpMessageWriter<?>> messageWriters() {
                return ServerResponseResultHandler.this.messageCodecConfigurer.getWriters();
            }

            @Override
            public List<ViewResolver> viewResolvers() {
                return ServerResponseResultHandler.this.viewResolvers;
            }
        });
    }
}

