/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.handler;

import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.reactive.handler.PathMatchResult;
import org.springframework.web.reactive.handler.PathPatternRegistry;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import reactor.core.publisher.Mono;

public abstract class AbstractUrlHandlerMapping
extends AbstractHandlerMapping {
    private boolean lazyInitHandlers = false;
    private PathPatternRegistry<Object> patternRegistry;

    public PathPatternRegistry<Object> getPatternRegistry() {
        return this.patternRegistry;
    }

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    public final Map<PathPattern, Object> getHandlerMap() {
        return this.patternRegistry.getPatternsMap();
    }

    public Mono<Object> getHandlerInternal(ServerWebExchange exchange) {
        Object handler;
        String lookupPath = exchange.getRequest().getPath().pathWithinApplication().value();
        try {
            handler = this.lookupHandler(lookupPath, exchange);
        }
        catch (Exception ex) {
            return Mono.error((Throwable)ex);
        }
        if (handler != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Mapping [" + lookupPath + "] to " + handler));
        } else if (handler == null && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("No handler mapping found for [" + lookupPath + "]"));
        }
        return Mono.justOrEmpty((Object)handler);
    }

    @Nullable
    protected Object lookupHandler(String lookupPath, ServerWebExchange exchange) throws Exception {
        Optional<PathMatchResult<Object>> matches = this.patternRegistry.findFirstMatch(lookupPath);
        if (matches.isPresent()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Matching patterns for request [" + lookupPath + "] are " + matches));
            }
            PathMatchResult<Object> bestMatch = matches.get();
            String pathWithinMapping = bestMatch.getPattern().extractPathWithinPattern(lookupPath);
            Object handler = bestMatch.getHandler();
            if (handler == null) {
                throw new IllegalStateException("Could not find handler for best pattern match [" + bestMatch + "]");
            }
            return this.handleMatch(handler, bestMatch.getPattern(), pathWithinMapping, exchange);
        }
        return null;
    }

    private Object handleMatch(Object handler, PathPattern bestMatch, String pathWithinMapping, ServerWebExchange exchange) throws Exception {
        if (handler instanceof String) {
            String handlerName = (String)handler;
            handler = this.obtainApplicationContext().getBean(handlerName);
        }
        this.validateHandler(handler, exchange);
        exchange.getAttributes().put(PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, pathWithinMapping);
        exchange.getAttributes().put(BEST_MATCHING_PATTERN_ATTRIBUTE, bestMatch);
        return handler;
    }

    protected void validateHandler(Object handler, ServerWebExchange exchange) throws Exception {
    }

    protected void registerHandler(String[] urlPaths, String beanName) throws BeansException, IllegalStateException {
        Assert.notNull((Object)urlPaths, (String)"URL path array must not be null");
        for (String urlPath : urlPaths) {
            this.registerHandler(urlPath, (Object)beanName);
        }
    }

    protected void registerHandler(String urlPath, Object handler) throws BeansException, IllegalStateException {
        Map<PathPattern, Object> patternsMap;
        Assert.notNull((Object)urlPath, (String)"URL path must not be null");
        Assert.notNull((Object)handler, (String)"Handler object must not be null");
        Object resolvedHandler = handler;
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            if (this.obtainApplicationContext().isSingleton(handlerName)) {
                resolvedHandler = this.obtainApplicationContext().getBean(handlerName);
            }
        }
        if (this.patternRegistry == null) {
            this.patternRegistry = new PathPatternRegistry(this.getPathPatternParser());
        }
        if ((patternsMap = this.patternRegistry.getPatternsMap()).containsKey(urlPath)) {
            Object mappedHandler = patternsMap.get(urlPath);
            if (mappedHandler != null && mappedHandler != resolvedHandler) {
                throw new IllegalStateException("Cannot map " + this.getHandlerDescription(handler) + " to URL path [" + urlPath + "]: There is already " + this.getHandlerDescription(mappedHandler) + " mapped.");
            }
        } else {
            this.patternRegistry.register(urlPath, resolvedHandler);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Mapped URL path [" + urlPath + "] onto " + this.getHandlerDescription(handler)));
        }
    }

    private String getHandlerDescription(Object handler) {
        return "handler " + (handler instanceof String ? "'" + handler + "'" : "of type [" + handler.getClass() + "]");
    }
}

