/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.result.condition.AbstractRequestCondition;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternComparator;
import org.springframework.web.util.pattern.PathPatternParser;

public final class PatternsRequestCondition
extends AbstractRequestCondition<PatternsRequestCondition> {
    private final List<PathPattern> patterns;
    private final PathPatternParser parser;

    public PatternsRequestCondition(String ... patterns) {
        this((Collection<String>)PatternsRequestCondition.asList(patterns), null);
    }

    public PatternsRequestCondition(String[] patterns, PathPatternParser patternParser) {
        this((Collection<String>)PatternsRequestCondition.asList(patterns), patternParser);
    }

    private PatternsRequestCondition(Collection<String> patterns, PathPatternParser patternParser) {
        this.parser = patternParser != null ? patternParser : new PathPatternParser();
        this.patterns = new ArrayList<PathPattern>();
        patterns.forEach(pattern -> {
            if (StringUtils.hasText((String)pattern) && !pattern.startsWith("/")) {
                pattern = "/" + pattern;
            }
            this.patterns.add(this.parser.parse(pattern));
        });
    }

    private PatternsRequestCondition(List<PathPattern> patterns, PathPatternParser patternParser) {
        this.patterns = patterns;
        this.parser = patternParser;
    }

    private static List<String> asList(String ... patterns) {
        return patterns != null ? Arrays.asList(patterns) : Collections.emptyList();
    }

    public Set<PathPattern> getPatterns() {
        return new TreeSet<PathPattern>(this.patterns);
    }

    public Set<String> getPatternStrings() {
        return this.patterns.stream().map(PathPattern::toString).collect(Collectors.toSet());
    }

    @Override
    protected Collection<PathPattern> getContent() {
        return this.patterns;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public PatternsRequestCondition combine(PatternsRequestCondition other) {
        ArrayList<PathPattern> combined = new ArrayList<PathPattern>();
        if (!this.patterns.isEmpty() && !other.patterns.isEmpty()) {
            for (PathPattern pattern1 : this.patterns) {
                for (PathPattern pattern2 : other.patterns) {
                    String combinedPattern = pattern1.combine(pattern2.getPatternString());
                    combined.add(this.parser.parse(combinedPattern));
                }
            }
        } else if (!this.patterns.isEmpty()) {
            combined.addAll(this.patterns);
        } else if (!other.patterns.isEmpty()) {
            combined.addAll(other.patterns);
        } else {
            combined.add(this.parser.parse(""));
        }
        return new PatternsRequestCondition((List<PathPattern>)combined, this.parser);
    }

    @Override
    @Nullable
    public PatternsRequestCondition getMatchingCondition(ServerWebExchange exchange) {
        if (this.patterns.isEmpty()) {
            return this;
        }
        String lookupPath = exchange.getRequest().getPath().pathWithinApplication().value();
        SortedSet<PathPattern> matches = this.getMatchingPatterns(lookupPath);
        return matches.isEmpty() ? null : new PatternsRequestCondition((List<PathPattern>)new ArrayList<PathPattern>(matches), this.parser);
    }

    public SortedSet<PathPattern> getMatchingPatterns(String lookupPath) {
        return this.patterns.stream().filter(pattern -> pattern.matches(lookupPath)).collect(Collectors.toCollection(() -> new TreeSet(new PathPatternComparator(lookupPath))));
    }

    @Override
    public int compareTo(PatternsRequestCondition other, ServerWebExchange exchange) {
        String lookupPath = exchange.getRequest().getPath().pathWithinApplication().value();
        PathPatternComparator comparator = new PathPatternComparator(lookupPath);
        Iterator iterator = this.patterns.stream().sorted(comparator).collect(Collectors.toList()).iterator();
        Iterator iteratorOther = other.getPatterns().stream().sorted(comparator).collect(Collectors.toList()).iterator();
        while (iterator.hasNext() && iteratorOther.hasNext()) {
            int result = comparator.compare((PathPattern)iterator.next(), (PathPattern)iteratorOther.next());
            if (result == 0) continue;
            return result;
        }
        if (iterator.hasNext()) {
            return -1;
        }
        if (iteratorOther.hasNext()) {
            return 1;
        }
        return 0;
    }
}

