/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Optional;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpCookie;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueSyncArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.ServerWebInputException;

public class CookieValueMethodArgumentResolver
extends AbstractNamedValueSyncArgumentResolver {
    public CookieValueMethodArgumentResolver(@Nullable ConfigurableBeanFactory factory, ReactiveAdapterRegistry registry) {
        super(factory, registry);
    }

    @Override
    public boolean supportsParameter(MethodParameter param) {
        return this.checkAnnotatedParamNoReactiveWrapper(param, CookieValue.class, (annot, type) -> true);
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        CookieValue ann = (CookieValue)parameter.getParameterAnnotation(CookieValue.class);
        Assert.state((ann != null ? 1 : 0) != 0, (String)"No CookieValue annotation");
        return new CookieValueNamedValueInfo(ann);
    }

    @Override
    protected Optional<Object> resolveNamedValue(String name, MethodParameter parameter, ServerWebExchange exchange) {
        HttpCookie cookie = (HttpCookie)exchange.getRequest().getCookies().getFirst((Object)name);
        Class paramType = parameter.getNestedParameterType();
        if (HttpCookie.class.isAssignableFrom(paramType)) {
            return Optional.ofNullable(cookie);
        }
        if (cookie != null) {
            return Optional.of(cookie.getValue());
        }
        return Optional.empty();
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) {
        String type = parameter.getNestedParameterType().getSimpleName();
        String reason = "Missing cookie '" + name + "' for method parameter of type " + type;
        throw new ServerWebInputException(reason, parameter);
    }

    private static class CookieValueNamedValueInfo
    extends AbstractNamedValueArgumentResolver.NamedValueInfo {
        private CookieValueNamedValueInfo(CookieValue annotation) {
            super(annotation.name(), annotation.required(), annotation.defaultValue());
        }
    }
}

