/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

public class ServerWebExchangeArgumentResolver
extends HandlerMethodArgumentResolverSupport
implements SyncHandlerMethodArgumentResolver {
    public ServerWebExchangeArgumentResolver(ReactiveAdapterRegistry adapterRegistry) {
        super(adapterRegistry);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return this.checkParameterTypeNoReactiveWrapper(parameter, type -> ServerWebExchange.class.isAssignableFrom((Class<?>)type) || ServerHttpRequest.class.isAssignableFrom((Class<?>)type) || ServerHttpResponse.class.isAssignableFrom((Class<?>)type) || HttpMethod.class == type);
    }

    @Override
    public Optional<Object> resolveArgumentValue(MethodParameter methodParameter, BindingContext context, ServerWebExchange exchange) {
        Class paramType = methodParameter.getParameterType();
        if (ServerWebExchange.class.isAssignableFrom(paramType)) {
            return Optional.of(exchange);
        }
        if (ServerHttpRequest.class.isAssignableFrom(paramType)) {
            return Optional.of(exchange.getRequest());
        }
        if (ServerHttpResponse.class.isAssignableFrom(paramType)) {
            return Optional.of(exchange.getResponse());
        }
        if (HttpMethod.class == paramType) {
            return Optional.ofNullable(exchange.getRequest().getMethod());
        }
        throw new IllegalArgumentException("Unknown parameter type: " + paramType + " in method: " + methodParameter.getMethod());
    }
}

