/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.client.DefaultClientRequestBuilder;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import reactor.core.publisher.Mono;

public interface ClientRequest {
    public HttpMethod method();

    public URI url();

    public HttpHeaders headers();

    public MultiValueMap<String, String> cookies();

    public BodyInserter<?, ? super ClientHttpRequest> body();

    default public Optional<Object> attribute(String name) {
        Map<String, Object> attributes = this.attributes();
        if (attributes.containsKey(name)) {
            return Optional.of(attributes.get(name));
        }
        return Optional.empty();
    }

    public Map<String, Object> attributes();

    public Mono<Void> writeTo(ClientHttpRequest var1, ExchangeStrategies var2);

    public static Builder from(ClientRequest other) {
        Assert.notNull((Object)other, (String)"'other' must not be null");
        return new DefaultClientRequestBuilder(other.method(), other.url()).headers(headers2 -> headers2.addAll((MultiValueMap)other.headers())).cookies(cookies -> cookies.addAll(other.cookies())).attributes(attributes -> attributes.putAll(other.attributes())).body(other.body());
    }

    public static Builder method(HttpMethod method2, URI url) {
        return new DefaultClientRequestBuilder(method2, url);
    }

    public static interface Builder {
        public Builder header(String var1, String ... var2);

        public Builder headers(Consumer<HttpHeaders> var1);

        public Builder cookie(String var1, String ... var2);

        public Builder cookies(Consumer<MultiValueMap<String, String>> var1);

        public Builder body(BodyInserter<?, ? super ClientHttpRequest> var1);

        public <S, P extends Publisher<S>> Builder body(P var1, Class<S> var2);

        public <S, P extends Publisher<S>> Builder body(P var1, ParameterizedTypeReference<S> var2);

        public Builder attribute(String var1, Object var2);

        public Builder attributes(Consumer<Map<String, Object>> var1);

        public ClientRequest build();
    }
}

