/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.function.client.WebClientException;

public class WebClientResponseException
extends WebClientException {
    private static final long serialVersionUID = 4127543205414951611L;
    private final int statusCode;
    private final String statusText;
    private final byte[] responseBody;
    private final HttpHeaders headers;
    private final Charset responseCharset;

    public WebClientResponseException(String message, int statusCode, String statusText, @Nullable HttpHeaders headers2, @Nullable byte[] responseBody, @Nullable Charset responseCharset) {
        super(message);
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.headers = headers2 != null ? headers2 : HttpHeaders.EMPTY;
        this.responseBody = responseBody != null ? responseBody : new byte[]{};
        this.responseCharset = responseCharset != null ? responseCharset : StandardCharsets.ISO_8859_1;
    }

    public HttpStatus getStatusCode() {
        return HttpStatus.valueOf((int)this.statusCode);
    }

    public int getRawStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public byte[] getResponseBodyAsByteArray() {
        return this.responseBody;
    }

    public String getResponseBodyAsString() {
        return new String(this.responseBody, this.responseCharset);
    }
}

