/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.core.CoroutinesUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverComposite;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class InvocableHandlerMethod
extends HandlerMethod {
    private static final Mono<Object[]> EMPTY_ARGS = Mono.just((Object)new Object[0]);
    private static final Object NO_ARG_VALUE = new Object();
    private HandlerMethodArgumentResolverComposite resolvers = new HandlerMethodArgumentResolverComposite();
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();

    public InvocableHandlerMethod(HandlerMethod handlerMethod) {
        super(handlerMethod);
    }

    public InvocableHandlerMethod(Object bean, Method method2) {
        super(bean, method2);
    }

    public void setArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        this.resolvers.addResolvers(resolvers);
    }

    public List<HandlerMethodArgumentResolver> getResolvers() {
        return this.resolvers.getResolvers();
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer nameDiscoverer) {
        this.parameterNameDiscoverer = nameDiscoverer;
    }

    public ParameterNameDiscoverer getParameterNameDiscoverer() {
        return this.parameterNameDiscoverer;
    }

    public void setReactiveAdapterRegistry(ReactiveAdapterRegistry registry) {
        this.reactiveAdapterRegistry = registry;
    }

    public Mono<HandlerResult> invoke(ServerWebExchange exchange, BindingContext bindingContext, Object ... providedArgs) {
        return this.getMethodArgumentValues(exchange, bindingContext, providedArgs).flatMap(args -> {
            Object value;
            try {
                ReflectionUtils.makeAccessible((Method)this.getBridgedMethod());
                Method method2 = this.getBridgedMethod();
                value = KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(method2.getDeclaringClass()) ? CoroutinesUtils.invokeHandlerMethod((Method)method2, (Object)this.getBean(), (Object[])args) : method2.invoke(this.getBean(), args);
            }
            catch (IllegalArgumentException ex) {
                this.assertTargetBean(this.getBridgedMethod(), this.getBean(), (Object[])args);
                String text = ex.getMessage() != null ? ex.getMessage() : "Illegal argument";
                return Mono.error((Throwable)new IllegalStateException(this.formatInvokeError(text, (Object[])args), ex));
            }
            catch (InvocationTargetException ex) {
                return Mono.error((Throwable)ex.getTargetException());
            }
            catch (Throwable ex) {
                return Mono.error((Throwable)new IllegalStateException(this.formatInvokeError("Invocation failure", (Object[])args), ex));
            }
            HttpStatus status = this.getResponseStatus();
            if (status != null) {
                exchange.getResponse().setStatusCode(status);
            }
            MethodParameter returnType = this.getReturnType();
            ReactiveAdapter adapter = this.reactiveAdapterRegistry.getAdapter(returnType.getParameterType());
            boolean asyncVoid = InvocableHandlerMethod.isAsyncVoidReturnType(returnType, adapter);
            if ((value == null || asyncVoid) && this.isResponseHandled((Object[])args, exchange)) {
                return asyncVoid ? Mono.from((Publisher)adapter.toPublisher(value)) : Mono.empty();
            }
            HandlerResult result = new HandlerResult((Object)this, value, returnType, bindingContext);
            return Mono.just((Object)result);
        });
    }

    private Mono<Object[]> getMethodArgumentValues(ServerWebExchange exchange, BindingContext bindingContext, Object ... providedArgs) {
        if (ObjectUtils.isEmpty((Object[])this.getMethodParameters())) {
            return EMPTY_ARGS;
        }
        MethodParameter[] parameters = this.getMethodParameters();
        ArrayList<Mono> argMonos = new ArrayList<Mono>(parameters.length);
        for (MethodParameter parameter : parameters) {
            parameter.initParameterNameDiscovery(this.parameterNameDiscoverer);
            Object providedArg = InvocableHandlerMethod.findProvidedArgument((MethodParameter)parameter, (Object[])providedArgs);
            if (providedArg != null) {
                argMonos.add(Mono.just((Object)providedArg));
                continue;
            }
            if (!this.resolvers.supportsParameter(parameter)) {
                return Mono.error((Throwable)new IllegalStateException(InvocableHandlerMethod.formatArgumentError((MethodParameter)parameter, (String)"No suitable resolver")));
            }
            try {
                argMonos.add(this.resolvers.resolveArgument(parameter, bindingContext, exchange).defaultIfEmpty(NO_ARG_VALUE).doOnError(cause -> this.logArgumentErrorIfNecessary(exchange, parameter, (Throwable)cause)));
            }
            catch (Exception ex) {
                this.logArgumentErrorIfNecessary(exchange, parameter, ex);
                argMonos.add(Mono.error((Throwable)ex));
            }
        }
        return Mono.zip(argMonos, values -> Stream.of(values).map(o -> o != NO_ARG_VALUE ? o : null).toArray());
    }

    private void logArgumentErrorIfNecessary(ServerWebExchange exchange, MethodParameter parameter, Throwable cause) {
        String message = cause.getMessage();
        if (!message.contains(parameter.getExecutable().toGenericString()) && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(exchange.getLogPrefix() + InvocableHandlerMethod.formatArgumentError((MethodParameter)parameter, (String)message)));
        }
    }

    private static boolean isAsyncVoidReturnType(MethodParameter returnType, @Nullable ReactiveAdapter adapter) {
        if (adapter != null && adapter.supportsEmpty()) {
            ParameterizedType type;
            if (adapter.isNoValue()) {
                return true;
            }
            Type parameterType = returnType.getGenericParameterType();
            if (parameterType instanceof ParameterizedType && (type = (ParameterizedType)parameterType).getActualTypeArguments().length == 1) {
                return Void.class.equals((Object)type.getActualTypeArguments()[0]);
            }
        }
        return false;
    }

    private boolean isResponseHandled(Object[] args, ServerWebExchange exchange) {
        if (this.getResponseStatus() != null || exchange.isNotModified()) {
            return true;
        }
        for (Object arg : args) {
            if (!(arg instanceof ServerHttpResponse) && !(arg instanceof ServerWebExchange)) continue;
            return true;
        }
        return false;
    }
}

