/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.core.MethodIntrospector;
import org.springframework.http.server.RequestPath;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractHandlerMethodMapping<T>
extends AbstractHandlerMapping
implements InitializingBean {
    private static final String SCOPED_TARGET_NAME_PREFIX = "scopedTarget.";
    private static final HandlerMethod PREFLIGHT_AMBIGUOUS_MATCH = new HandlerMethod((Object)new PreFlightAmbiguousMatchHandler(), ClassUtils.getMethod(PreFlightAmbiguousMatchHandler.class, (String)"handle", (Class[])new Class[0]));
    private static final CorsConfiguration ALLOW_CORS_CONFIG = new CorsConfiguration();
    private final MappingRegistry mappingRegistry = new MappingRegistry();

    public Map<T, HandlerMethod> getHandlerMethods() {
        this.mappingRegistry.acquireReadLock();
        try {
            Map<Object, HandlerMethod> map = Collections.unmodifiableMap(this.mappingRegistry.getRegistrations().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((MappingRegistration)entry.getValue()).handlerMethod)));
            return map;
        }
        finally {
            this.mappingRegistry.releaseReadLock();
        }
    }

    MappingRegistry getMappingRegistry() {
        return this.mappingRegistry;
    }

    public void registerMapping(T mapping, Object handler, Method method2) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Register \"" + mapping + "\" to " + method2.toGenericString()));
        }
        this.mappingRegistry.register(mapping, handler, method2);
    }

    public void unregisterMapping(T mapping) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Unregister mapping \"" + mapping));
        }
        this.mappingRegistry.unregister(mapping);
    }

    public void afterPropertiesSet() {
        this.initHandlerMethods();
        int total = this.getHandlerMethods().size();
        if (this.logger.isTraceEnabled() && total == 0 || this.logger.isDebugEnabled() && total > 0) {
            this.logger.debug((Object)(total + " mappings in " + this.formatMappingName()));
        }
    }

    protected void initHandlerMethods() {
        String[] beanNames;
        for (String beanName : beanNames = this.obtainApplicationContext().getBeanNamesForType(Object.class)) {
            Class beanType;
            block3: {
                if (beanName.startsWith(SCOPED_TARGET_NAME_PREFIX)) continue;
                beanType = null;
                try {
                    beanType = this.obtainApplicationContext().getType(beanName);
                }
                catch (Throwable ex) {
                    if (!this.logger.isTraceEnabled()) break block3;
                    this.logger.trace((Object)("Could not resolve type for bean '" + beanName + "'"), ex);
                }
            }
            if (beanType == null || !this.isHandler(beanType)) continue;
            this.detectHandlerMethods(beanName);
        }
        this.handlerMethodsInitialized(this.getHandlerMethods());
    }

    protected void detectHandlerMethods(Object handler) {
        Class handlerType;
        Class clazz = handlerType = handler instanceof String ? this.obtainApplicationContext().getType((String)handler) : handler.getClass();
        if (handlerType != null) {
            Class userType = ClassUtils.getUserClass((Class)handlerType);
            Map methods = MethodIntrospector.selectMethods((Class)userType, method2 -> this.getMappingForMethod(method2, userType));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.formatMappings(userType, methods));
            } else if (this.mappingsLogger.isDebugEnabled()) {
                this.mappingsLogger.debug((Object)this.formatMappings(userType, methods));
            }
            methods.forEach((method2, mapping) -> {
                Method invocableMethod = AopUtils.selectInvocableMethod((Method)method2, (Class)userType);
                this.registerHandlerMethod(handler, invocableMethod, mapping);
            });
        }
    }

    private String formatMappings(Class<?> userType, Map<Method, T> methods) {
        String packageName = ClassUtils.getPackageName(userType);
        String formattedType = StringUtils.hasText((String)packageName) ? Arrays.stream(packageName.split("\\.")).map(packageSegment -> packageSegment.substring(0, 1)).collect(Collectors.joining(".", "", "." + userType.getSimpleName())) : userType.getSimpleName();
        Function<Method, String> methodFormatter = method2 -> Arrays.stream(method2.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(",", "(", ")"));
        return methods.entrySet().stream().map(e -> {
            Method method2 = (Method)e.getKey();
            return e.getValue() + ": " + method2.getName() + (String)methodFormatter.apply(method2);
        }).collect(Collectors.joining("\n\t", "\n\t" + formattedType + ":\n\t", ""));
    }

    protected void registerHandlerMethod(Object handler, Method method2, T mapping) {
        this.mappingRegistry.register(mapping, handler, method2);
    }

    protected HandlerMethod createHandlerMethod(Object handler, Method method2) {
        if (handler instanceof String) {
            return new HandlerMethod((String)handler, (BeanFactory)this.obtainApplicationContext().getAutowireCapableBeanFactory(), (MessageSource)this.obtainApplicationContext(), method2);
        }
        return new HandlerMethod(handler, method2);
    }

    @Nullable
    protected CorsConfiguration initCorsConfiguration(Object handler, Method method2, T mapping) {
        return null;
    }

    protected void handlerMethodsInitialized(Map<T, HandlerMethod> handlerMethods) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<HandlerMethod> getHandlerInternal(ServerWebExchange exchange) {
        this.mappingRegistry.acquireReadLock();
        try {
            HandlerMethod handlerMethod;
            try {
                handlerMethod = this.lookupHandlerMethod(exchange);
            }
            catch (Exception ex) {
                Mono mono = Mono.error((Throwable)ex);
                this.mappingRegistry.releaseReadLock();
                return mono;
            }
            if (handlerMethod != null) {
                handlerMethod = handlerMethod.createWithResolvedBean();
            }
            Mono mono = Mono.justOrEmpty((Object)handlerMethod);
            return mono;
        }
        finally {
            this.mappingRegistry.releaseReadLock();
        }
    }

    @Nullable
    protected HandlerMethod lookupHandlerMethod(ServerWebExchange exchange) throws Exception {
        ArrayList<Match> matches = new ArrayList<Match>();
        List directPathMatches = this.mappingRegistry.getMappingsByDirectPath(exchange);
        if (directPathMatches != null) {
            this.addMatchingMappings(directPathMatches, matches, exchange);
        }
        if (matches.isEmpty()) {
            this.addMatchingMappings(this.mappingRegistry.getRegistrations().keySet(), matches, exchange);
        }
        if (!matches.isEmpty()) {
            MatchComparator comparator = new MatchComparator(this.getMappingComparator(exchange));
            matches.sort(comparator);
            Match bestMatch = (Match)matches.get(0);
            if (matches.size() > 1) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)(exchange.getLogPrefix() + matches.size() + " matching mappings: " + matches));
                }
                if (CorsUtils.isPreFlightRequest((ServerHttpRequest)exchange.getRequest())) {
                    for (Match match : matches) {
                        if (!match.hasCorsConfig()) continue;
                        return PREFLIGHT_AMBIGUOUS_MATCH;
                    }
                } else {
                    Match secondBestMatch = (Match)matches.get(1);
                    if (comparator.compare(bestMatch, secondBestMatch) == 0) {
                        Method m1 = bestMatch.getHandlerMethod().getMethod();
                        Method m2 = secondBestMatch.getHandlerMethod().getMethod();
                        RequestPath path2 = exchange.getRequest().getPath();
                        throw new IllegalStateException("Ambiguous handler methods mapped for '" + path2 + "': {" + m1 + ", " + m2 + "}");
                    }
                }
            }
            this.handleMatch(bestMatch.mapping, bestMatch.getHandlerMethod(), exchange);
            return bestMatch.getHandlerMethod();
        }
        return this.handleNoMatch(this.mappingRegistry.getRegistrations().keySet(), exchange);
    }

    private void addMatchingMappings(Collection<T> mappings, List<Match> matches, ServerWebExchange exchange) {
        for (T mapping : mappings) {
            T match = this.getMatchingMapping(mapping, exchange);
            if (match == null) continue;
            matches.add(new Match(match, this.mappingRegistry.getRegistrations().get(mapping)));
        }
    }

    protected void handleMatch(T mapping, HandlerMethod handlerMethod, ServerWebExchange exchange) {
        String lookupPath = exchange.getRequest().getPath().pathWithinApplication().value();
        exchange.getAttributes().put(PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, lookupPath);
    }

    @Nullable
    protected HandlerMethod handleNoMatch(Set<T> mappings, ServerWebExchange exchange) throws Exception {
        return null;
    }

    @Override
    protected boolean hasCorsConfigurationSource(Object handler) {
        return super.hasCorsConfigurationSource(handler) || handler instanceof HandlerMethod && this.mappingRegistry.getCorsConfiguration((HandlerMethod)handler) != null;
    }

    @Override
    protected CorsConfiguration getCorsConfiguration(Object handler, ServerWebExchange exchange) {
        CorsConfiguration corsConfig = super.getCorsConfiguration(handler, exchange);
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            if (handlerMethod.equals((Object)PREFLIGHT_AMBIGUOUS_MATCH)) {
                return ALLOW_CORS_CONFIG;
            }
            CorsConfiguration methodConfig = this.mappingRegistry.getCorsConfiguration(handlerMethod);
            corsConfig = corsConfig != null ? corsConfig.combine(methodConfig) : methodConfig;
        }
        return corsConfig;
    }

    protected abstract boolean isHandler(Class<?> var1);

    @Nullable
    protected abstract T getMappingForMethod(Method var1, Class<?> var2);

    protected Set<String> getDirectPaths(T mapping) {
        return Collections.emptySet();
    }

    @Nullable
    protected abstract T getMatchingMapping(T var1, ServerWebExchange var2);

    protected abstract Comparator<T> getMappingComparator(ServerWebExchange var1);

    static {
        ALLOW_CORS_CONFIG.addAllowedOriginPattern("*");
        ALLOW_CORS_CONFIG.addAllowedMethod("*");
        ALLOW_CORS_CONFIG.addAllowedHeader("*");
        ALLOW_CORS_CONFIG.setAllowCredentials(Boolean.valueOf(true));
    }

    private static class PreFlightAmbiguousMatchHandler {
        private PreFlightAmbiguousMatchHandler() {
        }

        public void handle() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private class MatchComparator
    implements Comparator<Match> {
        private final Comparator<T> comparator;

        public MatchComparator(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(Match match1, Match match2) {
            return this.comparator.compare(match1.mapping, match2.mapping);
        }
    }

    private class Match {
        private final T mapping;
        private final MappingRegistration<T> registration;

        public Match(T mapping, MappingRegistration<T> registration) {
            this.mapping = mapping;
            this.registration = registration;
        }

        public T getMapping() {
            return this.mapping;
        }

        public HandlerMethod getHandlerMethod() {
            return this.registration.getHandlerMethod();
        }

        public boolean hasCorsConfig() {
            return this.registration.hasCorsConfig();
        }

        public String toString() {
            return this.mapping.toString();
        }
    }

    static class MappingRegistration<T> {
        private final T mapping;
        private final HandlerMethod handlerMethod;
        private final Set<String> directPaths;
        private final boolean corsConfig;

        public MappingRegistration(T mapping, HandlerMethod handlerMethod, @Nullable Set<String> directPaths, boolean corsConfig) {
            Assert.notNull(mapping, (String)"Mapping must not be null");
            Assert.notNull((Object)handlerMethod, (String)"HandlerMethod must not be null");
            this.mapping = mapping;
            this.handlerMethod = handlerMethod;
            this.directPaths = directPaths != null ? directPaths : Collections.emptySet();
            this.corsConfig = corsConfig;
        }

        public T getMapping() {
            return this.mapping;
        }

        public HandlerMethod getHandlerMethod() {
            return this.handlerMethod;
        }

        public Set<String> getDirectPaths() {
            return this.directPaths;
        }

        public boolean hasCorsConfig() {
            return this.corsConfig;
        }
    }

    class MappingRegistry {
        private final Map<T, MappingRegistration<T>> registry = new HashMap();
        private final MultiValueMap<String, T> pathLookup = new LinkedMultiValueMap();
        private final Map<HandlerMethod, CorsConfiguration> corsLookup = new ConcurrentHashMap<HandlerMethod, CorsConfiguration>();
        private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

        MappingRegistry() {
        }

        public Map<T, MappingRegistration<T>> getRegistrations() {
            return this.registry;
        }

        @Nullable
        public List<T> getMappingsByDirectPath(ServerWebExchange exchange) {
            String path2 = exchange.getRequest().getPath().pathWithinApplication().value();
            return (List)this.pathLookup.get((Object)path2);
        }

        @Nullable
        public CorsConfiguration getCorsConfiguration(HandlerMethod handlerMethod) {
            HandlerMethod original = handlerMethod.getResolvedFromHandlerMethod();
            return this.corsLookup.get(original != null ? original : handlerMethod);
        }

        public void acquireReadLock() {
            this.readWriteLock.readLock().lock();
        }

        public void releaseReadLock() {
            this.readWriteLock.readLock().unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(T mapping, Object handler, Method method2) {
            this.readWriteLock.writeLock().lock();
            try {
                HandlerMethod handlerMethod = AbstractHandlerMethodMapping.this.createHandlerMethod(handler, method2);
                this.validateMethodMapping(handlerMethod, mapping);
                Set<String> directPaths = AbstractHandlerMethodMapping.this.getDirectPaths(mapping);
                for (String path2 : directPaths) {
                    this.pathLookup.add((Object)path2, mapping);
                }
                CorsConfiguration corsConfig = AbstractHandlerMethodMapping.this.initCorsConfiguration(handler, method2, mapping);
                if (corsConfig != null) {
                    corsConfig.validateAllowCredentials();
                    this.corsLookup.put(handlerMethod, corsConfig);
                }
                this.registry.put(mapping, new MappingRegistration(mapping, handlerMethod, directPaths, corsConfig != null));
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }

        private void validateMethodMapping(HandlerMethod handlerMethod, T mapping) {
            HandlerMethod existingHandlerMethod;
            MappingRegistration registration = this.registry.get(mapping);
            HandlerMethod handlerMethod2 = existingHandlerMethod = registration != null ? registration.getHandlerMethod() : null;
            if (existingHandlerMethod != null && !existingHandlerMethod.equals((Object)handlerMethod)) {
                throw new IllegalStateException("Ambiguous mapping. Cannot map '" + handlerMethod.getBean() + "' method \n" + handlerMethod + "\nto " + mapping + ": There is already '" + existingHandlerMethod.getBean() + "' bean method\n" + existingHandlerMethod + " mapped.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister(T mapping) {
            this.readWriteLock.writeLock().lock();
            try {
                MappingRegistration registration = this.registry.remove(mapping);
                if (registration == null) {
                    return;
                }
                for (String path2 : registration.getDirectPaths()) {
                    List mappings = (List)this.pathLookup.get((Object)path2);
                    if (mappings == null) continue;
                    mappings.remove(registration.getMapping());
                    if (!mappings.isEmpty()) continue;
                    this.pathLookup.remove((Object)path2);
                }
                this.corsLookup.remove(registration.getHandlerMethod());
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }
}

