/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Hints;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ProblemDetail;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.HandlerResultHandlerSupport;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageWriterResultHandler
extends HandlerResultHandlerSupport {
    protected static final String COROUTINES_FLOW_CLASS_NAME = "kotlinx.coroutines.flow.Flow";
    private final List<HttpMessageWriter<?>> messageWriters;
    private final List<MediaType> problemMediaTypes = Arrays.asList(MediaType.APPLICATION_PROBLEM_JSON, MediaType.APPLICATION_PROBLEM_XML);

    protected AbstractMessageWriterResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver) {
        this(messageWriters, contentTypeResolver, ReactiveAdapterRegistry.getSharedInstance());
    }

    protected AbstractMessageWriterResultHandler(List<HttpMessageWriter<?>> messageWriters, RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        super(contentTypeResolver, adapterRegistry);
        Assert.notEmpty(messageWriters, (String)"At least one message writer is required");
        this.messageWriters = messageWriters;
    }

    public List<HttpMessageWriter<?>> getMessageWriters() {
        return this.messageWriters;
    }

    protected Mono<Void> writeBody(@Nullable Object body2, MethodParameter bodyParameter, ServerWebExchange exchange) {
        return this.writeBody(body2, bodyParameter, null, exchange);
    }

    protected Mono<Void> writeBody(@Nullable Object body2, MethodParameter bodyParameter, @Nullable MethodParameter actualParam, ServerWebExchange exchange) {
        MediaType contentType;
        MediaType bestMediaType;
        ResolvableType actualElementType;
        ResolvableType elementType;
        Mono publisher;
        ResolvableType bodyType = ResolvableType.forMethodParameter((MethodParameter)bodyParameter);
        ResolvableType actualType = actualParam != null ? ResolvableType.forMethodParameter((MethodParameter)actualParam) : bodyType;
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(bodyType.resolve(), body2);
        if (adapter != null) {
            publisher = adapter.toPublisher(body2);
            boolean isUnwrapped = KotlinDetector.isSuspendingFunction((Method)bodyParameter.getMethod()) && !COROUTINES_FLOW_CLASS_NAME.equals(bodyType.toClass().getName()) && !Flux.class.equals((Object)bodyType.toClass());
            ResolvableType genericType = isUnwrapped ? bodyType : bodyType.getGeneric(new int[0]);
            actualElementType = elementType = this.getElementType(adapter, genericType);
        } else {
            publisher = Mono.justOrEmpty((Object)body2);
            ResolvableType bodyInstanceType = ResolvableType.forInstance((Object)body2);
            if (bodyType.toClass() == Object.class && body2 != null) {
                actualElementType = bodyInstanceType;
                elementType = bodyInstanceType;
            } else {
                actualElementType = body2 == null || bodyInstanceType.hasUnresolvableGenerics() ? bodyType : bodyInstanceType;
                elementType = bodyType;
            }
        }
        if (elementType.resolve() == Void.TYPE || elementType.resolve() == Void.class) {
            return Mono.from((Publisher)publisher);
        }
        try {
            bestMediaType = this.selectMediaType(exchange, () -> this.getMediaTypesFor(elementType));
        }
        catch (NotAcceptableStatusException ex) {
            HttpStatusCode statusCode = exchange.getResponse().getStatusCode();
            if (statusCode != null && statusCode.isError()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring error response content (if any). " + ex.getReason()));
                }
                return Mono.empty();
            }
            throw ex;
        }
        if (bestMediaType == null && elementType.toClass().equals(ProblemDetail.class)) {
            bestMediaType = this.selectMediaType(exchange, () -> this.getMediaTypesFor(elementType), this.problemMediaTypes);
        }
        if (bestMediaType != null) {
            String logPrefix = exchange.getLogPrefix();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(logPrefix + (publisher instanceof Mono ? "0..1" : "0..N") + " [" + elementType + "]"));
            }
            for (HttpMessageWriter<?> writer : this.getMessageWriters()) {
                if (!writer.canWrite(actualElementType, bestMediaType)) continue;
                return writer.write((Publisher)publisher, actualType, elementType, bestMediaType, exchange.getRequest(), exchange.getResponse(), Hints.from((String)Hints.LOG_PREFIX_HINT, (Object)logPrefix));
            }
        }
        boolean isPresentMediaType = (contentType = exchange.getResponse().getHeaders().getContentType()) != null && contentType.equals((Object)bestMediaType);
        Set producibleTypes = (Set)exchange.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        if (isPresentMediaType || !CollectionUtils.isEmpty((Collection)producibleTypes)) {
            return Mono.error((Throwable)new HttpMessageNotWritableException("No Encoder for [" + elementType + "] with preset Content-Type '" + contentType + "'"));
        }
        List<MediaType> mediaTypes = this.getMediaTypesFor(elementType);
        if (bestMediaType == null && mediaTypes.isEmpty()) {
            return Mono.error((Throwable)new IllegalStateException("No HttpMessageWriter for " + elementType));
        }
        return Mono.error((Throwable)new NotAcceptableStatusException(mediaTypes));
    }

    private ResolvableType getElementType(ReactiveAdapter adapter, ResolvableType genericType) {
        if (adapter.isNoValue()) {
            return ResolvableType.forClass(Void.class);
        }
        if (genericType != ResolvableType.NONE) {
            return genericType;
        }
        return ResolvableType.forClass(Object.class);
    }

    private List<MediaType> getMediaTypesFor(ResolvableType elementType) {
        ArrayList<MediaType> writableMediaTypes = new ArrayList<MediaType>();
        for (HttpMessageWriter<?> converter : this.getMessageWriters()) {
            if (!converter.canWrite(elementType, null)) continue;
            writableMediaTypes.addAll(converter.getWritableMediaTypes(elementType));
        }
        return writableMediaTypes;
    }
}

