/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import org.jspecify.annotations.Nullable;
import org.springframework.web.accept.InvalidApiVersionException;
import org.springframework.web.accept.MissingApiVersionException;
import org.springframework.web.server.ServerWebExchange;

public interface ApiVersionStrategy {
    public @Nullable String resolveVersion(ServerWebExchange var1);

    public Comparable<?> parseVersion(String var1);

    public void validateVersion(@Nullable Comparable<?> var1, ServerWebExchange var2) throws MissingApiVersionException, InvalidApiVersionException;

    public @Nullable Comparable<?> getDefaultVersion();

    default public @Nullable Comparable<?> resolveParseAndValidateVersion(ServerWebExchange exchange2) {
        Comparable<?> version;
        String value = this.resolveVersion(exchange2);
        if (value == null) {
            version = this.getDefaultVersion();
        } else {
            try {
                version = this.parseVersion(value);
            }
            catch (Exception ex) {
                throw new InvalidApiVersionException(value, null, ex);
            }
        }
        this.validateVersion(version, exchange2);
        return version;
    }

    public void handleDeprecations(Comparable<?> var1, ServerWebExchange var2);
}

