/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import org.springframework.beans.BeansException;
import org.springframework.util.CollectionUtils;
import org.springframework.web.portlet.handler.AbstractMapBasedHandlerMapping;

public class PortletModeHandlerMapping
extends AbstractMapBasedHandlerMapping {
    private final Map portletModeMap = new HashMap();

    public void setMappings(Properties mappings) {
        this.portletModeMap.putAll(mappings);
    }

    public void setPortletModeMap(Map portletModeMap) {
        this.portletModeMap.putAll(portletModeMap);
    }

    public void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.registerHandlers(this.portletModeMap);
    }

    protected void registerHandlers(Map portletModeMap) throws BeansException {
        if (CollectionUtils.isEmpty((Map)portletModeMap)) {
            this.logger.warn((Object)"Neither 'portletModeMap' nor 'mappings' set on PortletModeHandlerMapping");
        } else {
            Iterator it = portletModeMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String modeKey = (String)entry.getKey();
                PortletMode mode = new PortletMode(modeKey);
                Object handler = entry.getValue();
                this.registerHandler(mode, handler);
            }
        }
    }

    protected Object getLookupKey(PortletRequest request) throws Exception {
        return request.getPortletMode();
    }
}

