/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.context.request.SessionScope;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.portlet.context.PortletConfigPropertySource;
import org.springframework.web.portlet.context.PortletContextPropertySource;
import org.springframework.web.portlet.context.PortletContextScope;
import org.springframework.web.portlet.context.PortletRequestAttributes;
import org.springframework.web.portlet.context.PortletWebRequest;

public abstract class PortletApplicationContextUtils {
    public static ApplicationContext getWebApplicationContext(PortletContext pc) {
        Assert.notNull((Object)pc, (String)"PortletContext must not be null");
        Object attr = pc.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (attr == null) {
            return null;
        }
        if (attr instanceof RuntimeException) {
            throw (RuntimeException)attr;
        }
        if (attr instanceof Error) {
            throw (Error)attr;
        }
        if (!(attr instanceof ApplicationContext)) {
            throw new IllegalStateException("Root context attribute is not of type WebApplicationContext: " + attr);
        }
        return (ApplicationContext)attr;
    }

    public static ApplicationContext getRequiredWebApplicationContext(PortletContext pc) throws IllegalStateException {
        ApplicationContext wac = PortletApplicationContextUtils.getWebApplicationContext(pc);
        if (wac == null) {
            throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
        }
        return wac;
    }

    static void registerPortletApplicationScopes(ConfigurableListableBeanFactory bf, PortletContext pc) {
        bf.registerScope("request", (Scope)new RequestScope());
        bf.registerScope("session", (Scope)new SessionScope(false));
        bf.registerScope("globalSession", (Scope)new SessionScope(true));
        if (pc != null) {
            PortletContextScope appScope = new PortletContextScope(pc);
            bf.registerScope("application", (Scope)appScope);
            pc.setAttribute(PortletContextScope.class.getName(), (Object)appScope);
        }
        bf.registerResolvableDependency(PortletRequest.class, (Object)new RequestObjectFactory());
        bf.registerResolvableDependency(PortletSession.class, (Object)new SessionObjectFactory());
        bf.registerResolvableDependency(WebRequest.class, (Object)new WebRequestObjectFactory());
    }

    static void registerEnvironmentBeans(ConfigurableListableBeanFactory bf, ServletContext servletContext, PortletContext portletContext, PortletConfig portletConfig) {
        if (servletContext != null && !bf.containsBean("servletContext")) {
            bf.registerSingleton("servletContext", (Object)servletContext);
        }
        if (portletContext != null && !bf.containsBean("portletContext")) {
            bf.registerSingleton("portletContext", (Object)portletContext);
        }
        if (portletConfig != null && !bf.containsBean("portletConfig")) {
            bf.registerSingleton("portletConfig", (Object)portletConfig);
        }
        if (!bf.containsBean("contextParameters")) {
            String paramName;
            Enumeration paramNameEnum;
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            if (portletContext != null) {
                paramNameEnum = portletContext.getInitParameterNames();
                while (paramNameEnum.hasMoreElements()) {
                    paramName = (String)paramNameEnum.nextElement();
                    parameterMap.put(paramName, portletContext.getInitParameter(paramName));
                }
            }
            if (portletConfig != null) {
                paramNameEnum = portletConfig.getInitParameterNames();
                while (paramNameEnum.hasMoreElements()) {
                    paramName = (String)paramNameEnum.nextElement();
                    parameterMap.put(paramName, portletConfig.getInitParameter(paramName));
                }
            }
            bf.registerSingleton("contextParameters", Collections.unmodifiableMap(parameterMap));
        }
        if (!bf.containsBean("contextAttributes")) {
            HashMap<String, Object> attributeMap = new HashMap<String, Object>();
            if (portletContext != null) {
                Enumeration attrNameEnum = portletContext.getAttributeNames();
                while (attrNameEnum.hasMoreElements()) {
                    String attrName = (String)attrNameEnum.nextElement();
                    attributeMap.put(attrName, portletContext.getAttribute(attrName));
                }
            }
            bf.registerSingleton("contextAttributes", Collections.unmodifiableMap(attributeMap));
        }
    }

    public static void initPortletPropertySources(MutablePropertySources propertySources, ServletContext servletContext, PortletContext portletContext, PortletConfig portletConfig) {
        Assert.notNull((Object)propertySources, (String)"propertySources must not be null");
        WebApplicationContextUtils.initServletPropertySources((MutablePropertySources)propertySources, (ServletContext)servletContext);
        if (portletContext != null && propertySources.contains("portletContextInitParams")) {
            propertySources.replace("portletContextInitParams", (PropertySource)new PortletContextPropertySource("portletContextInitParams", portletContext));
        }
        if (portletConfig != null && propertySources.contains("portletConfigInitParams")) {
            propertySources.replace("portletConfigInitParams", (PropertySource)new PortletConfigPropertySource("portletConfigInitParams", portletConfig));
        }
    }

    private static PortletRequestAttributes currentRequestAttributes() {
        RequestAttributes requestAttr = RequestContextHolder.currentRequestAttributes();
        if (!(requestAttr instanceof PortletRequestAttributes)) {
            throw new IllegalStateException("Current request is not a portlet request");
        }
        return (PortletRequestAttributes)requestAttr;
    }

    private static class WebRequestObjectFactory
    implements ObjectFactory<WebRequest>,
    Serializable {
        private WebRequestObjectFactory() {
        }

        public WebRequest getObject() {
            return new PortletWebRequest(PortletApplicationContextUtils.currentRequestAttributes().getRequest());
        }

        public String toString() {
            return "Current PortletWebRequest";
        }
    }

    private static class SessionObjectFactory
    implements ObjectFactory<PortletSession>,
    Serializable {
        private SessionObjectFactory() {
        }

        public PortletSession getObject() {
            return PortletApplicationContextUtils.currentRequestAttributes().getRequest().getPortletSession();
        }

        public String toString() {
            return "Current PortletSession";
        }
    }

    private static class RequestObjectFactory
    implements ObjectFactory<PortletRequest>,
    Serializable {
        private RequestObjectFactory() {
        }

        public PortletRequest getObject() {
            return PortletApplicationContextUtils.currentRequestAttributes().getRequest();
        }

        public String toString() {
            return "Current PortletRequest";
        }
    }
}

