/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.ui.context.Theme;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.EscapedErrors;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class RequestContext {
    public static final String DEFAULT_THEME_NAME = "theme";
    public static final String JSTL_LOCALE_ATTRIBUTE = "javax.servlet.jsp.jstl.fmt.locale";
    protected static final String REQUEST_SCOPE_SUFFIX = ".request";
    protected static final String SESSION_SCOPE_SUFFIX = ".session";
    protected static final String APPLICATION_SCOPE_SUFFIX = ".application";
    private HttpServletRequest request;
    private Map model;
    private WebApplicationContext webApplicationContext;
    private Locale locale;
    private Theme theme;
    private boolean defaultHtmlEscape;
    private UrlPathHelper urlPathHelper;
    private Map errorsMap;

    public RequestContext(HttpServletRequest request) {
        this.initContext(request, null, null);
    }

    public RequestContext(HttpServletRequest request, ServletContext servletContext) {
        this.initContext(request, servletContext, null);
    }

    public RequestContext(HttpServletRequest request, Map model) {
        this.initContext(request, null, model);
    }

    public RequestContext(HttpServletRequest request, ServletContext servletContext, Map model) {
        this.initContext(request, servletContext, model);
    }

    protected RequestContext() {
    }

    protected void initContext(HttpServletRequest request, ServletContext servletContext, Map model) {
        this.request = request;
        this.model = model;
        this.webApplicationContext = RequestContextUtils.getWebApplicationContext((ServletRequest)request, servletContext);
        try {
            this.locale = RequestContextUtils.getLocale(request);
        }
        catch (IllegalStateException ex) {
            this.locale = this.getFallbackLocale();
        }
        try {
            this.theme = RequestContextUtils.getTheme(request);
        }
        catch (IllegalStateException ex) {
            this.theme = this.getFallbackTheme();
        }
        this.defaultHtmlEscape = WebUtils.isDefaultHtmlEscape((ServletContext)this.webApplicationContext.getServletContext());
        this.urlPathHelper = new UrlPathHelper();
    }

    protected Locale getFallbackLocale() {
        Locale locale = (Locale)this.getRequest().getAttribute(JSTL_LOCALE_ATTRIBUTE);
        if (locale == null && (locale = (Locale)this.getRequest().getAttribute("javax.servlet.jsp.jstl.fmt.locale.request")) == null) {
            HttpSession session = this.getRequest().getSession(false);
            if (session != null && (locale = (Locale)session.getAttribute(JSTL_LOCALE_ATTRIBUTE)) == null) {
                locale = (Locale)session.getAttribute("javax.servlet.jsp.jstl.fmt.locale.session");
            }
            if (locale == null && (locale = (Locale)this.getServletContext().getAttribute(JSTL_LOCALE_ATTRIBUTE)) == null && (locale = (Locale)this.getServletContext().getAttribute("javax.servlet.jsp.jstl.fmt.locale.application")) == null) {
                locale = this.getRequest().getLocale();
            }
        }
        return locale;
    }

    protected Theme getFallbackTheme() {
        return this.getWebApplicationContext().getTheme(DEFAULT_THEME_NAME);
    }

    protected final HttpServletRequest getRequest() {
        return this.request;
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected final ServletContext getServletContext() {
        return this.webApplicationContext.getServletContext();
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final Theme getTheme() {
        return this.theme;
    }

    public void setDefaultHtmlEscape(boolean defaultHtmlEscape) {
        this.defaultHtmlEscape = defaultHtmlEscape;
    }

    public boolean isDefaultHtmlEscape() {
        return this.defaultHtmlEscape;
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper != null ? urlPathHelper : new UrlPathHelper();
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public String getContextPath() {
        return this.urlPathHelper.getContextPath(this.request);
    }

    public String getRequestUri() {
        return this.urlPathHelper.getRequestUri(this.request);
    }

    public String getMessage(String code, String defaultMessage) {
        return this.getMessage(code, null, defaultMessage, this.defaultHtmlEscape);
    }

    public String getMessage(String code, Object[] args, String defaultMessage) {
        return this.getMessage(code, args, defaultMessage, this.defaultHtmlEscape);
    }

    public String getMessage(String code, List args, String defaultMessage) {
        return this.getMessage(code, args != null ? args.toArray() : null, defaultMessage, this.defaultHtmlEscape);
    }

    public String getMessage(String code, Object[] args, String defaultMessage, boolean htmlEscape) {
        String msg = this.webApplicationContext.getMessage(code, args, defaultMessage, this.locale);
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    public String getMessage(String code) throws NoSuchMessageException {
        return this.getMessage(code, null, this.defaultHtmlEscape);
    }

    public String getMessage(String code, Object[] args) throws NoSuchMessageException {
        return this.getMessage(code, args, this.defaultHtmlEscape);
    }

    public String getMessage(String code, List args) throws NoSuchMessageException {
        return this.getMessage(code, args != null ? args.toArray() : null, this.defaultHtmlEscape);
    }

    public String getMessage(String code, Object[] args, boolean htmlEscape) throws NoSuchMessageException {
        String msg = this.webApplicationContext.getMessage(code, args, this.locale);
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    public String getMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return this.getMessage(resolvable, this.defaultHtmlEscape);
    }

    public String getMessage(MessageSourceResolvable resolvable, boolean htmlEscape) throws NoSuchMessageException {
        String msg = this.webApplicationContext.getMessage(resolvable, this.locale);
        return htmlEscape ? HtmlUtils.htmlEscape((String)msg) : msg;
    }

    public String getThemeMessage(String code, String defaultMessage) {
        return this.theme.getMessageSource().getMessage(code, null, defaultMessage, this.locale);
    }

    public String getThemeMessage(String code, Object[] args, String defaultMessage) {
        return this.theme.getMessageSource().getMessage(code, args, defaultMessage, this.locale);
    }

    public String getThemeMessage(String code, List args, String defaultMessage) {
        return this.theme.getMessageSource().getMessage(code, args != null ? args.toArray() : null, defaultMessage, this.locale);
    }

    public String getThemeMessage(String code) throws NoSuchMessageException {
        return this.theme.getMessageSource().getMessage(code, null, this.locale);
    }

    public String getThemeMessage(String code, Object[] args) throws NoSuchMessageException {
        return this.theme.getMessageSource().getMessage(code, args, this.locale);
    }

    public String getThemeMessage(String code, List args) throws NoSuchMessageException {
        return this.theme.getMessageSource().getMessage(code, args != null ? args.toArray() : null, this.locale);
    }

    public String getThemeMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return this.theme.getMessageSource().getMessage(resolvable, this.locale);
    }

    public Errors getErrors(String name) {
        return this.getErrors(name, this.defaultHtmlEscape);
    }

    public Errors getErrors(String name, boolean htmlEscape) {
        if (this.errorsMap == null) {
            this.errorsMap = new HashMap();
        }
        Errors errors = (Errors)this.errorsMap.get(name);
        boolean put = false;
        if (errors == null) {
            errors = (Errors)this.getModelObject(BindException.ERROR_KEY_PREFIX + name);
            if (errors == null) {
                return null;
            }
            put = true;
        }
        if (htmlEscape && !(errors instanceof EscapedErrors)) {
            errors = new EscapedErrors(errors);
            put = true;
        } else if (!htmlEscape && errors instanceof EscapedErrors) {
            errors = ((EscapedErrors)errors).getSource();
            put = true;
        }
        if (put) {
            this.errorsMap.put(name, errors);
        }
        return errors;
    }

    protected Object getModelObject(String modelName) {
        if (this.model != null) {
            return this.model.get(modelName);
        }
        return this.request.getAttribute(modelName);
    }

    public BindStatus getBindStatus(String path) throws IllegalStateException {
        return new BindStatus(this, path, this.defaultHtmlEscape);
    }

    public BindStatus getBindStatus(String path, boolean htmlEscape) throws IllegalStateException {
        return new BindStatus(this, path, htmlEscape);
    }
}

