/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.PropertiesBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.web.context.support.GenericWebApplicationContext;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractCachingViewResolver;

public class ResourceBundleViewResolver
extends AbstractCachingViewResolver
implements Ordered,
DisposableBean {
    public static final String DEFAULT_BASENAME = "views";
    private int order = Integer.MAX_VALUE;
    private String[] basenames = new String[]{"views"};
    private String defaultParentView;
    private final Map cachedFactories = new HashMap();
    static /* synthetic */ Class class$org$springframework$web$servlet$View;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setBasename(String basename) {
        this.setBasenames(new String[]{basename});
    }

    public void setBasenames(String[] basenames) {
        this.basenames = basenames;
    }

    public void setDefaultParentView(String defaultParentView) {
        this.defaultParentView = defaultParentView;
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        try {
            return (View)this.initFactory(locale).getBean(viewName, class$org$springframework$web$servlet$View == null ? (class$org$springframework$web$servlet$View = ResourceBundleViewResolver.class$("org.springframework.web.servlet.View")) : class$org$springframework$web$servlet$View);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    protected synchronized BeanFactory initFactory(Locale locale) throws Exception {
        BeanFactory parsedBundle;
        BeanFactory beanFactory = parsedBundle = this.isCache() ? (BeanFactory)this.cachedFactories.get(locale) : null;
        if (parsedBundle != null) {
            return parsedBundle;
        }
        GenericWebApplicationContext factory = new GenericWebApplicationContext();
        factory.setParent(this.getApplicationContext());
        factory.setServletContext(this.getServletContext());
        PropertiesBeanDefinitionReader reader = new PropertiesBeanDefinitionReader((BeanDefinitionRegistry)factory);
        reader.setDefaultParentBean(this.defaultParentView);
        for (int i = 0; i < this.basenames.length; ++i) {
            ResourceBundle bundle = ResourceBundle.getBundle(this.basenames[i], locale, Thread.currentThread().getContextClassLoader());
            reader.registerBeanDefinitions(bundle);
        }
        factory.refresh();
        if (this.isCache()) {
            this.cachedFactories.put(locale, factory);
        }
        return factory;
    }

    public void destroy() throws BeansException {
        Iterator it = this.cachedFactories.values().iterator();
        while (it.hasNext()) {
            ConfigurableApplicationContext factory = (ConfigurableApplicationContext)it.next();
            factory.close();
        }
        this.cachedFactories.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

