/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.util.UrlPathHelper;

public abstract class AbstractUrlHandlerMapping
extends AbstractHandlerMapping {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private Object rootHandler;
    private boolean lazyInitHandlers = false;
    private final Map handlerMap = new HashMap();

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public void setRootHandler(Object rootHandler) {
        this.rootHandler = rootHandler;
    }

    public Object getRootHandler() {
        return this.rootHandler;
    }

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        Object handler;
        String lookupPath = this.urlPathHelper.getLookupPathForRequest(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up handler for [" + lookupPath + "]"));
        }
        if ((handler = this.lookupHandler(lookupPath, request)) == null) {
            if ("/".equals(lookupPath)) {
                handler = this.getRootHandler();
            }
            if (handler == null) {
                handler = this.getDefaultHandler();
            }
            if (handler != null) {
                this.exposePathWithinMapping(lookupPath, request);
            }
        }
        return handler;
    }

    protected Object lookupHandler(String urlPath, HttpServletRequest request) {
        Object handler = this.handlerMap.get(urlPath);
        if (handler != null) {
            this.exposePathWithinMapping(urlPath, request);
            return handler;
        }
        String bestPathMatch = null;
        Iterator it = this.handlerMap.keySet().iterator();
        while (it.hasNext()) {
            String registeredPath = (String)it.next();
            if (!this.pathMatcher.match(registeredPath, urlPath) || bestPathMatch != null && bestPathMatch.length() > registeredPath.length()) continue;
            bestPathMatch = registeredPath;
        }
        if (bestPathMatch != null) {
            handler = this.handlerMap.get(bestPathMatch);
            this.exposePathWithinMapping(this.pathMatcher.extractPathWithinPattern(bestPathMatch, urlPath), request);
        }
        return handler;
    }

    protected void exposePathWithinMapping(String pathWithinMapping, HttpServletRequest request) {
        request.setAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, (Object)pathWithinMapping);
    }

    protected void registerHandler(String[] urlPaths, String beanName) throws BeansException, IllegalStateException {
        Assert.notNull((Object)urlPaths, (String)"URL path array must not be null");
        for (int j = 0; j < urlPaths.length; ++j) {
            this.registerHandler(urlPaths[j], (Object)beanName);
        }
    }

    protected void registerHandler(String urlPath, Object handler) throws BeansException, IllegalStateException {
        Assert.notNull((Object)urlPath, (String)"URL path must not be null");
        Assert.notNull((Object)handler, (String)"Handler object must not be null");
        Object mappedHandler = this.handlerMap.get(urlPath);
        if (mappedHandler != null) {
            throw new IllegalStateException("Cannot map handler [" + handler + "] to URL path [" + urlPath + "]: There is already handler [" + mappedHandler + "] mapped.");
        }
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            if (this.getApplicationContext().isSingleton(handlerName)) {
                handler = this.getApplicationContext().getBean(handlerName);
            }
        }
        if (urlPath.equals("/")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Root mapping to handler [" + handler + "]"));
            }
            this.setRootHandler(handler);
        } else if (urlPath.equals("/*")) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Default mapping to handler [" + handler + "]"));
            }
            this.setDefaultHandler(handler);
        } else {
            this.handlerMap.put(urlPath, handler);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Mapped URL path [" + urlPath + "] onto handler [" + handler + "]"));
            }
        }
    }

    public final Map getHandlerMap() {
        return Collections.unmodifiableMap(this.handlerMap);
    }
}

