/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import javax.servlet.http.HttpServletRequest;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.support.JstlUtils;
import org.springframework.web.servlet.view.InternalResourceView;

public class JstlView
extends InternalResourceView {
    private MessageSource messageSource;

    public JstlView() {
    }

    public JstlView(String url) {
        super(url);
    }

    public JstlView(String url, MessageSource messageSource) {
        super(url);
        this.messageSource = messageSource;
    }

    protected void initApplicationContext() {
        super.initApplicationContext();
        if (this.messageSource == null) {
            this.messageSource = JstlUtils.getJstlAwareMessageSource(this.getServletContext(), (MessageSource)this.getApplicationContext());
        }
    }

    protected void exposeHelpers(HttpServletRequest request) throws Exception {
        JstlUtils.exposeLocalizationContext(request, this.messageSource);
    }
}

