/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.jasperreports;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import org.springframework.ui.jasperreports.JasperReportsUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.view.jasperreports.AbstractJasperReportsView;

public abstract class AbstractJasperReportsSingleFormatView
extends AbstractJasperReportsView {
    private static final int OUTPUT_BYTE_ARRAY_INITIAL_SIZE = 4096;

    protected void renderReport(JasperPrint populatedReport, Map model, HttpServletResponse response) throws Exception {
        JRExporter exporter = this.createExporter();
        Map mergedExporterParameters = this.mergeExporterParameters(model);
        if (!CollectionUtils.isEmpty((Map)mergedExporterParameters)) {
            exporter.setParameters(mergedExporterParameters);
        }
        if (this.useWriter()) {
            String contentType = this.getContentType();
            String encoding = (String)exporter.getParameter(JRExporterParameter.CHARACTER_ENCODING);
            if (encoding != null && contentType != null && contentType.toLowerCase().indexOf(";charset=") == -1) {
                contentType = contentType + ";charset=" + encoding;
            }
            response.setContentType(contentType);
            JasperReportsUtils.render((JRExporter)exporter, (JasperPrint)populatedReport, (Writer)response.getWriter());
        } else {
            response.setContentType(this.getContentType());
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            JasperReportsUtils.render((JRExporter)exporter, (JasperPrint)populatedReport, (OutputStream)baos);
            response.setContentLength(baos.size());
            ServletOutputStream out = response.getOutputStream();
            baos.writeTo((OutputStream)out);
            out.flush();
        }
    }

    protected Map mergeExporterParameters(Map model) {
        HashMap mergedParameters = new HashMap();
        Map convertedExporterParameters = this.getConvertedExporterParameters();
        if (!CollectionUtils.isEmpty((Map)convertedExporterParameters)) {
            mergedParameters.putAll(convertedExporterParameters);
        }
        Iterator it = model.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (!(key instanceof JRExporterParameter)) continue;
            Object value = model.get(key);
            Object convertedValue = this.convertParameterValue((JRExporterParameter)key, value);
            mergedParameters.put(key, convertedValue);
        }
        return mergedParameters;
    }

    protected abstract JRExporter createExporter();

    protected abstract boolean useWriter();
}

